package fr.inra.agrosyst.api.services.practiced;

/*
 * #%L
 * Agrosyst :: API
 * $Id: PracticedCropCycleConnectionDto.java 4795 2015-02-17 06:32:47Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/practiced/PracticedCropCycleConnectionDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;

import java.io.Serializable;
import java.util.List;

/**
 * Connexion entre deux cutures a deux rang differents pouvant comporter une culture intermédiaire.
 * 
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class PracticedCropCycleConnectionDto implements Serializable {

    private static final long serialVersionUID = 1297913628926444728L;

    protected String sourceId;
    protected String targetId;
    protected String intermediateCroppingPlanEntryCode;
    protected String intermediateCropName;
    protected String label;
    protected Double croppingPlanEntryFrequency;
    protected boolean notUsedForThisCampaign;

    protected List<PracticedInterventionDto> interventions;

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public String getSourceId() {
        return sourceId;
    }

    public String getTargetId() {
        return targetId;
    }
    
    public String getIntermediateCroppingPlanEntryCode() {
        return intermediateCroppingPlanEntryCode;
    }

    public void setIntermediateCroppingPlanEntryCode(String intermediateCroppingPlanEntryCode) {
        this.intermediateCroppingPlanEntryCode = intermediateCroppingPlanEntryCode;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Double getCroppingPlanEntryFrequency() {
        return croppingPlanEntryFrequency;
    }

    public void setCroppingPlanEntryFrequency(Double croppingPlanEntryFrequency) {
        this.croppingPlanEntryFrequency = croppingPlanEntryFrequency;
    }
    
    public List<PracticedInterventionDto> getInterventions() {
        return interventions;
    }

    public void setInterventions(List<PracticedInterventionDto> interventions) {
        this.interventions = interventions;
    }

    public String getIntermediateCropName() {
        return intermediateCropName;
    }

    public void setIntermediateCropName(String intermediateCropName) {
        this.intermediateCropName = intermediateCropName;
    }

    public boolean isNotUsedForThisCampaign() {
        return notUsedForThisCampaign;
    }

    public void setNotUsedForThisCampaign(boolean notUsedForThisCampaign) {
        this.notUsedForThisCampaign = notUsedForThisCampaign;
    }

    public void addIntervention(PracticedInterventionDto interventionDto) {
        if (interventions == null) {
            interventions = Lists.newArrayList();
        }
        interventions.add(interventionDto);
    }
}
