package fr.inra.agrosyst.api.services.practiced;

/*
 * #%L
 * Agrosyst :: API
 * $Id: DuplicateCropCyclesContext.java 4972 2015-06-09 13:14:05Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/practiced/DuplicateCropCyclesContext.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractInput;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import org.apache.commons.lang3.tuple.Pair;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

/**
 * Context de duplication pour l'ensemble des objet de la graphe "systeme synthétisé".
 *
 * @author Eric Chatellier
 */
public class DuplicateCropCyclesContext implements Serializable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6608039291236218854L;

    /** for practiced System */
    protected PracticedSystem practicedSystem;
    protected PracticedSystem practicedSystemClone;

    /** common to PracticedSystems and Effective crop cycle */
    protected Map<String, Pair<CroppingPlanEntry, Map<String, CroppingPlanSpecies>>> fromSpeciesByCropCode;
    protected Map<String, Pair<CroppingPlanEntry, Map<String, CroppingPlanSpecies>>> speciesByCropCode;

    protected Collection<String> toolsCouplingsCode;
    protected Map<AbstractAction, AbstractAction> actionCache = Maps.newHashMap();
    protected Map<AbstractInput, AbstractInput> inputCache = Maps.newHashMap();
    protected String targetedCropCode;

    public PracticedSystem getPracticedSystem() {
        return practicedSystem;
    }

    public void setPracticedSystem(PracticedSystem practicedSystem) {
        this.practicedSystem = practicedSystem;
    }

    public PracticedSystem getPracticedSystemClone() {
        return practicedSystemClone;
    }

    public void setPracticedSystemClone(PracticedSystem practicedSystemClone) {
        this.practicedSystemClone = practicedSystemClone;
    }

    public Map<AbstractAction, AbstractAction> getActionCache() {
        return actionCache;
    }

    public Map<AbstractInput, AbstractInput> getInputCache() {
        return inputCache;
    }

    public Map<String, Pair<CroppingPlanEntry, Map<String, CroppingPlanSpecies>>> getSpeciesByCropCode() {
        return speciesByCropCode;
    }

    public void setSpeciesByCropCode(Map<String, Pair<CroppingPlanEntry, Map<String, CroppingPlanSpecies>>> speciesByCropCode) {
        this.speciesByCropCode = speciesByCropCode;
    }

    public Map<String, Pair<CroppingPlanEntry, Map<String, CroppingPlanSpecies>>> getFromSpeciesByCropCode() {
        return fromSpeciesByCropCode;
    }

    public void setFromSpeciesByCropCode(Map<String, Pair<CroppingPlanEntry, Map<String, CroppingPlanSpecies>>> fromSpeciesByCropCode) {
        this.fromSpeciesByCropCode = fromSpeciesByCropCode;
    }

    public Collection<String> getToolsCouplingsCode() {
        return toolsCouplingsCode;
    }

    public void setToolsCouplingsCode(Collection<String> toolsCouplingsCode) {
        this.toolsCouplingsCode = toolsCouplingsCode;
    }

    public String getTargetedCropCode() {
        return targetedCropCode;
    }

    public void setTargetedCropCode(String targetedCropCode) {
        this.targetedCropCode = targetedCropCode;
    }
}
