package fr.inra.agrosyst.api.services.practiced;

/*
 * #%L
 * Agrosyst :: API
 * $Id: CropCycleModelDto.java 3965 2014-04-02 11:36:31Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/practiced/CropCycleModelDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;

/**
 * Un model représente un model de culture pouvant servir à:
 * - creer un noeud dans un cycle pluriannuel de culture assolées
 * - choisir une culture dans un cycle pluriannuel de culture pérennes.
 * 
 * Cela permet de définir une cuture à un rang donné.
 * 
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class CropCycleModelDto implements Serializable {

    private static final long serialVersionUID = -9206223811128306689L;

    protected String croppingPlanEntryCode;
    protected String label;
    protected boolean intermediate;
    protected Double croppingPlanSellingPrice;

    public String getCroppingPlanEntryCode() {
        return croppingPlanEntryCode;
    }

    public void setCroppingPlanEntryCode(String croppingPlanEntryCode) {
        this.croppingPlanEntryCode = croppingPlanEntryCode;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isIntermediate() {
        return intermediate;
    }

    public void setIntermediate(boolean intermediate) {
        this.intermediate = intermediate;
    }

    public void setCroppingPlanSellingPrice(Double croppingPlanSellingPrice) {
        this.croppingPlanSellingPrice = croppingPlanSellingPrice;
    }


}
