package fr.inra.agrosyst.api.services.plot;

/*
 * #%L
 * Agrosyst :: API
 * $Id: Plots.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/plot/Plots.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Function;

import fr.inra.agrosyst.api.entities.SolHorizon;

public class Plots {

    public static final Function<SolHorizon, SolHorizonDto> SOL_HORIZON_TO_DTO = new Function<SolHorizon, SolHorizonDto>() {
        @Override
        public SolHorizonDto apply(SolHorizon input) {
            SolHorizonDto result = new SolHorizonDto();
            result.setTopiaId(input.getTopiaId());
            result.setLowRating(input.getLowRating());
            result.setStoniness(input.getStoniness());
            result.setComment(input.getComment());
            if (input.getSolTexture() != null) {
                result.setSolTextureId(input.getSolTexture().getTopiaId());
            }
            return result;
        }
    };
}
