package fr.inra.agrosyst.api.services.performance;

/*
 * #%L
 * Agrosyst :: API
 * $Id: PerformanceService.java 3855 2014-03-24 11:53:07Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/performance/PerformanceService.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.InputStream;
import java.util.List;

import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.PlotDto;
import fr.inra.agrosyst.api.services.domain.ZoneDto;

/**
 * Performance service.
 * 
 * @author Eric Chatellier
 */
public interface PerformanceService extends AgrosystService {

    ResultList<PerformanceDto> getFilteredPerformances(PerformanceFilter performanceFilter);

    Performance getPerformance(String performanceTopiaId);

    Performance createOrUpdatePerformance(Performance performance, List<String> domainIds,
                                          List<String> growingSystemIds, List<String> plotIds, List<String> zoneIds);

    InputStream downloadPerformances(String performanceTopiaId);

    List<PlotDto> getPlots(List<String> domainIds);

    List<ZoneDto> getZones(List<String> plotIds);

    /**
     * Suppression d'une performance.
     * 
     * @param performanceIds performance id to delete
     */
    void deletePerformance(List<String> performanceIds);

    /**
     * Compute performance and generate performance file.
     * 
     * This method is called by {@code PerformanceThread}.
     * 
     * @param performanceId performanceId to generate file
     */
    void generatePerformanceFile(String performanceId);

}
