package fr.inra.agrosyst.api.services.performance;

/*
 * #%L
 * Agrosyst :: API
 * $Id: PerformanceFilter.java 3344 2014-02-19 17:08:37Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/performance/PerformanceFilter.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.effective.EffectiveZoneFilter;

/**
 * Filter containing data used to filter growing systems list
 *
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class PerformanceFilter extends EffectiveZoneFilter {

    private static final long serialVersionUID = -7962037010032341849L;

    protected String performanceName;

    protected boolean practiced;

    public void setPerformanceName(String performanceName) {
        this.performanceName = performanceName;
    }
    
    public String getPerformanceName() {
        return performanceName;
    }
    
    public void setPracticed(boolean practiced) {
        this.practiced = practiced;
    }
    
    public boolean isPracticed() {
        return practiced;
    }
}
