package fr.inra.agrosyst.api.services.performance;

/*
 * #%L
 * Agrosyst :: API
 * $Id: PerformanceDto.java 3963 2014-04-02 09:42:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/performance/PerformanceDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import fr.inra.agrosyst.api.entities.performance.PerformanceState;
import fr.inra.agrosyst.api.services.domain.DomainDto;
import fr.inra.agrosyst.api.services.domain.PlotDto;
import fr.inra.agrosyst.api.services.domain.ZoneDto;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemDto;

/**
 * @author Arnaud Thimel (Code Lutin)
 */
public class PerformanceDto implements Serializable {

    private static final long serialVersionUID = 4918416523728390408L;

    protected String topiaId;
    protected String name;
    protected Date updateDate;
    protected PerformanceState computeStatus;
    protected List<DomainDto> domains;
    protected List<GrowingSystemDto> growingSystems;
    protected List<PlotDto> plots;
    protected List<ZoneDto> zones;

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public PerformanceState getComputeStatus() {
        return computeStatus;
    }

    public void setComputeStatus(PerformanceState computeStatus) {
        this.computeStatus = computeStatus;
    }

    public List<DomainDto> getDomains() {
        return domains;
    }

    public void setDomains(List<DomainDto> domains) {
        this.domains = domains;
    }

    public List<GrowingSystemDto> getGrowingSystems() {
        return growingSystems;
    }

    public void setGrowingSystems(List<GrowingSystemDto> growingSystems) {
        this.growingSystems = growingSystems;
    }

    public List<PlotDto> getPlots() {
        return plots;
    }

    public void setPlots(List<PlotDto> plots) {
        this.plots = plots;
    }

    public List<ZoneDto> getZones() {
        return zones;
    }

    public void setZones(List<ZoneDto> zones) {
        this.zones = zones;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((topiaId == null) ? 0 : topiaId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        PerformanceDto other = (PerformanceDto) obj;
        if (topiaId == null) {
            if (other.topiaId != null)
                return false;
        } else if (!topiaId.equals(other.topiaId))
            return false;
        return true;
    }
}
