package fr.inra.agrosyst.api.services.network;

/*
 * #%L
 * Agrosyst :: API
 * $Id: SmallNetworkDto.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/network/SmallNetworkDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;

import fr.inra.agrosyst.api.entities.Network;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class SmallNetworkDto implements Serializable {

    private static final long serialVersionUID = 7917435804024155776L;

    protected String id;
    protected String label;

    public SmallNetworkDto(Network network) {
        this.id = network.getTopiaId();
        this.label = network.getName();
    }

    public SmallNetworkDto(String id, String label) {
        this.id = id;
        this.label = label;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        SmallNetworkDto that = (SmallNetworkDto) o;

        if (!id.equals(that.id)) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }

}
