package fr.inra.agrosyst.api.services.network;

/*
 * #%L
 * Agrosyst :: API
 * $Id: NetworkIndicators.java 3338 2014-02-19 13:49:29Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/network/NetworkIndicators.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;
import java.util.List;

import fr.inra.agrosyst.api.services.common.GrowingSystemsIndicator;

/**
 * @author Arnaud Thimel (Code Lutin)
 */
public class NetworkIndicators implements Serializable {

    private static final long serialVersionUID = -4917760932760266557L;

    protected long domainsCount;
    protected long activeDomainsCount;

    protected long growingPlansCount;
    protected long activeGrowingPlansCount;

    protected long subNetworksCount;
    protected long activeSubNetworksCount;

    protected List<GrowingSystemsIndicator> growingSystems;

    public long getDomainsCount() {
        return domainsCount;
    }

    public void setDomainsCount(long domainsCount) {
        this.domainsCount = domainsCount;
    }

    public long getActiveDomainsCount() {
        return activeDomainsCount;
    }

    public void setActiveDomainsCount(long activeDomainsCount) {
        this.activeDomainsCount = activeDomainsCount;
    }

    public long getGrowingPlansCount() {
        return growingPlansCount;
    }

    public void setGrowingPlansCount(long growingPlansCount) {
        this.growingPlansCount = growingPlansCount;
    }

    public long getActiveGrowingPlansCount() {
        return activeGrowingPlansCount;
    }

    public void setActiveGrowingPlansCount(long activeGrowingPlansCount) {
        this.activeGrowingPlansCount = activeGrowingPlansCount;
    }

    public long getSubNetworksCount() {
        return subNetworksCount;
    }

    public void setSubNetworksCount(long subNetworksCount) {
        this.subNetworksCount = subNetworksCount;
    }

    public long getActiveSubNetworksCount() {
        return activeSubNetworksCount;
    }

    public void setActiveSubNetworksCount(long activeSubNetworksCount) {
        this.activeSubNetworksCount = activeSubNetworksCount;
    }

    public List<GrowingSystemsIndicator> getGrowingSystems() {
        return growingSystems;
    }

    public void setGrowingSystems(List<GrowingSystemsIndicator> growingSystems) {
        this.growingSystems = growingSystems;
    }
}
