package fr.inra.agrosyst.api.services.network;

/*
 * #%L
 * Agrosyst :: API
 * $Id: NetworkConnectionDto.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/network/NetworkConnectionDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class NetworkConnectionDto implements Serializable {
    private static final long serialVersionUID = -57932571652346565L;

    protected String sourceId;
    protected String targetId;

    public NetworkConnectionDto(String sourceId, String targetId) {
        this.sourceId = sourceId;
        this.targetId = targetId;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getTargetId() {
        return targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        NetworkConnectionDto that = (NetworkConnectionDto) o;

        if (!sourceId.equals(that.sourceId)) {
            return false;
        }
        if (!targetId.equals(that.targetId)) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        int result = sourceId.hashCode();
        result = 31 * result + targetId.hashCode();
        return result;
    }
}
