package fr.inra.agrosyst.api.services.measurement;

/*
 * #%L
 * Agrosyst :: API
 * $Id: ProtocoleVgObsFilter.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/measurement/ProtocoleVgObsFilter.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

/**
 * Protocol filter.
 * 
 * @author Eric Chatellier
 */
public class ProtocoleVgObsFilter {

    /** Protocole VgObs (colonne B de l’onglet « protocole VgObs »). */
    protected String label;

    /** Nuisible (si protocole VgObs identifié, colonne P de l’onglet « protocole VgObs ». */
    protected String pest;

    /** Stade organisme observé (si protocole VgObs identifié, colonne Q de l’onglet « protocole VgObs ». */
    protected String stade;

    /** Support organe observé (si protocole VgObs identifié, colonne Y de l’onglet « protocole VgObs ». */
    protected String support;

    /** Type de notation (si protocole VgObs identifié, colonne AE de l’onglet « protocole VgObs ». */
    protected String observation;

    /** Valeur qualitative (si protocole VgObs identifié, colonne AS de l’onglet « protocole VgObs ». */
    protected String qualitative;

    /** colonne AJ de l’onglet « protocole VgObs ». */
    protected String unit;

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getPest() {
        return pest;
    }

    public void setPest(String pest) {
        this.pest = pest;
    }

    public String getStade() {
        return stade;
    }

    public void setStade(String stade) {
        this.stade = stade;
    }

    public String getSupport() {
        return support;
    }

    public void setSupport(String support) {
        this.support = support;
    }

    public String getObservation() {
        return observation;
    }

    public void setObservation(String observation) {
        this.observation = observation;
    }

    public String getQualitative() {
        return qualitative;
    }

    public void setQualitative(String qualitative) {
        this.qualitative = qualitative;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
}
