package fr.inra.agrosyst.api.services.measurement;

/*
 * #%L
 * Agrosyst :: API
 * $Id: MeasurementService.java 4015 2014-04-17 16:22:33Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/measurement/MeasurementService.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;

import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.VariableType;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.measure.MeasurementSession;
import fr.inra.agrosyst.api.entities.measure.MeasurementType;
import fr.inra.agrosyst.api.entities.referential.RefActaSubstanceActive;
import fr.inra.agrosyst.api.entities.referential.RefAdventice;
import fr.inra.agrosyst.api.entities.referential.RefMesure;
import fr.inra.agrosyst.api.entities.referential.RefNuisibleEDI;
import fr.inra.agrosyst.api.entities.referential.RefProtocoleVgObs;
import fr.inra.agrosyst.api.entities.referential.RefStadeEDI;
import fr.inra.agrosyst.api.entities.referential.RefStadeNuisibleEDI;
import fr.inra.agrosyst.api.entities.referential.RefSupportOrganeEDI;
import fr.inra.agrosyst.api.entities.referential.RefTypeNotationEDI;
import fr.inra.agrosyst.api.entities.referential.RefUnitesQualifiantEDI;
import fr.inra.agrosyst.api.entities.referential.RefValeurQualitativeEDI;
import fr.inra.agrosyst.api.services.AgrosystService;

public interface MeasurementService extends AgrosystService {

    /**
     * Find zone by topia id.
     * 
     * @param zoneTopiaId zone id
     * @return zone
     */
    Zone getZone(String zoneTopiaId);

    /**
     * Get all measurement session for zone
     * @param zone zone
     * @return sessions
     */
    List<MeasurementSession> getZoneMeasurementSessions(Zone zone);

    /**
     * Update measurement sessions for zone.
     * 
     * @param zone zone
     * @param sessions sessions
     */
    void updateMeasurementSessions(Zone zone, Collection<MeasurementSession> sessions);

    /**
     * Recupère les cultures en places sur la zone en fonction des cycles de cultures réalisés.
     * 
     * @param zone zone
     * @return main cropping plan entries
     */
    Set<CroppingPlanEntry> getZoneCroppingPlanEntries(Zone zone);

    List<VariableType> findAllVariableTypes(MeasurementType measurementType);

    /**
     * Find all variable.
     * 
     * @param measurementType measurement category
     * @param variableType variable type (can be empty)
     * @return variables
     */
    List<RefMesure> findAllVariables(MeasurementType measurementType, VariableType variableType);

    List<RefSupportOrganeEDI> findAllSupportOrganeEDI();

    /**
     * Retourne les entites de produit commercial en retournant un sous ensemble unique
     * sur le champs nom_commun_sa.
     * 
     * @return
     */
    List<RefActaSubstanceActive> findDistinctSubstanceActives();

    List<RefAdventice> findAllAdventices();

    List<RefStadeEDI> findAllStadeEdi(String cropFamily, String vegetativeProfile);

    List<String> findAllProtocoleVgObsLabels();

    List<String> findAllProtocoleVgObsPests(ProtocoleVgObsFilter filter);

    List<String> findAllProtocoleVgObsStades(ProtocoleVgObsFilter filter);

    List<String> findAllProtocoleVgObsSupports(ProtocoleVgObsFilter filter);

    List<String> findAllProtocoleVgObsObservations(ProtocoleVgObsFilter filter);

    List<String> findAllProtocoleVgObsQualitatives(ProtocoleVgObsFilter filter);

    List<String> findAllProtocoleVgObsUnits(ProtocoleVgObsFilter filter);

    List<RefProtocoleVgObs> findAllProtocoleVgObsQualifiers(ProtocoleVgObsFilter filter);

    /**
     * Recherche les nuisibles EDI utilisées pour les observations hors protocole vgobs.
     * 
     * @return les nuisibles
     */
    List<BioAgressorType> findAllEdiPestTypes();

    /**
     * Recherche les nuisibles EDI utilisées pour les observations hors protocole vgobs.
     * 
     *
     * @param pestType filtre suivant le type
     * @return nuisible edi
     */
    List<RefNuisibleEDI> findAllEdiPests(BioAgressorType pestType);

    /**
     * Retourne l'ensemble des stades EDI utilisé pour les observation hors protcole vgobs.
     * 
     * @return les stades nuisibles
     */
    List<RefStadeNuisibleEDI> findAllEdiPestStades();

    /**
     * Recherche les unités définies dans le referentiel protocole vgbos, mais utilisé hors
     * protocole vgobs.
     * 
     * @return les unités
     */
    List<String> findAllVgObsUnits();

    /**
     * Retourne les types de notations EDI utilisés pour les observations hors protcole vgobs.
     * 
     * @return tous les types de notations EDI
     */
    List<RefTypeNotationEDI> findAllEdiNotations();

    /**
     * Retourne les valeurs qualifiants EDI utilisés pour les observations hors protcole vgobs.
     * 
     * @return valeur qualifiant EDI
     */
    List<RefValeurQualitativeEDI> findAllEdiQualitatives();

    /**
     * Retourne les unites qualifaint edi utilisés pour les observations hors protcole vgobs.
     * 
     * @return toutes les unités qualifiants edi
     */
    List<RefUnitesQualifiantEDI> findAllEdiQualifiantUnits();

    /**
     * Export selected effective Measurments id as excel sheet.
     * 
     * @param zoneIds zone ids
     * @return stream
     */
    InputStream exportEffectiveMeasurementsAsXlsStream(List<String> zoneIds);

    /**
     * Import effective measurement from stream.
     * 
     * @param is input stream
     */
    void importEffectiveMeasurementsForXlsStream(InputStream is);
}
