package fr.inra.agrosyst.api.services.managementmode;

/*
 * #%L
 * Agrosyst :: API
 * $Id: ManagementModes.java 4279 2014-08-29 15:16:22Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/managementmode/ManagementModes.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.managementmode.Section;
import fr.inra.agrosyst.api.entities.managementmode.Strategy;

public class ManagementModes {

    public static final Function<Section, SectionDto> SECTION_TO_DTO = new Function<Section, SectionDto>() {
        @Override
        public SectionDto apply(Section input) {
            SectionDto result = new SectionDto();
            result.setTopiaId(input.getTopiaId());
            result.setAgronomicObjective(input.getAgronomicObjective());
            result.setExpectedResult(input.getExpectedResult());
            result.setSectionType(input.getSectionType());
            result.setCategoryObjective(input.getCategoryObjective());
            result.setCategoryStrategy(input.getCategoryStrategy());
            result.setBioAgressorType(input.getBioAgressorType());
            if (input.getBioAgressor() != null) {
                result.setBioAgressorTopiaId(input.getBioAgressor().getTopiaId());
                result.setBioAgressorLabel(input.getBioAgressor().getLabel());
            }
            if (input.getStrategies() != null) {
                result.setStrategiesDto(Lists.transform(input.getStrategies(), STRATEGY_TO_DTO));
            }
            return result;
        }
    };
    
    public static final Function<Strategy, StrategyDto> STRATEGY_TO_DTO = new Function<Strategy, StrategyDto>() {
        @Override
        public StrategyDto apply(Strategy input) {
            StrategyDto result = new StrategyDto();
            result.setTopiaId(input.getTopiaId());
            result.setExplanation(input.getExplanation());
            result.setStrategyType(input.getStrategyType());
            result.setCroppingPlanManagmentName(input.getCroppingPlanManagmentName());
            result.setMultiannual(input.isMultiannual());
            if (input.getCroppingPlanEntry() != null) {
               result.setCroppingPlanEntryId(input.getCroppingPlanEntry().getTopiaId());
               result.setCroppingPlanEntrycode(input.getCroppingPlanEntry().getCode());
            }
            if (input.getRules() != null) {
                result.setDecisionRuleIds(Sets.newHashSet(Collections2.transform(input.getRules(), Entities.GET_TOPIA_ID)));
            }
            return result;
        }
    };

}
