package fr.inra.agrosyst.api.services.managementmode;

/*
 * #%L
 * Agrosyst :: API
 * $Id: ManagementModeDto.java 3963 2014-04-02 09:42:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/managementmode/ManagementModeDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.commons.lang3.StringUtils;

import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemDto;

/**
 * Created by davidcosse on 24/01/14.
 */
public class ManagementModeDto {

    /**
     * Topia id of planned Management Mode
     */
    protected String plannedManagementModeId;

    /**
     * TopiaId of Observed Management Mode
     */
    protected String observedManagementModeId;

    /**
     * growing System common for both ManagmentModes
     */
    protected GrowingSystemDto growingSystem;

    public String getPlannedManagementModeId() {
        return plannedManagementModeId;
    }

    public void setPlannedManagementModeId(String plannedManagementModeId) {
        this.plannedManagementModeId = plannedManagementModeId;
    }

    public String getObservedManagementModeId() {
        return observedManagementModeId;
    }

    public void setObservedManagementModeId(String observedManagementModeId) {
        this.observedManagementModeId = observedManagementModeId;
    }

    public GrowingSystemDto getGrowingSystem() {
        return growingSystem;
    }

    public void setGrowingSystem(GrowingSystemDto growingSystem) {
        this.growingSystem = growingSystem;
    }

    public String getDtoId() {
        String dtoId;
        if (StringUtils.isNotBlank(plannedManagementModeId) && StringUtils.isNotBlank(observedManagementModeId)) {
            dtoId = plannedManagementModeId + observedManagementModeId;
        } else if (StringUtils.isNotBlank(plannedManagementModeId)){
            dtoId = plannedManagementModeId;
        } else if (StringUtils.isNotBlank(observedManagementModeId)){
            dtoId = observedManagementModeId;
        } else {
            dtoId = null;
        }
        return dtoId;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        String dtoId = getDtoId();
        result = prime * result + ((dtoId == null) ? 0 : dtoId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        String dtoId = getDtoId();
        ManagementModeDto other = (ManagementModeDto) obj;
        if (dtoId == null) {
            if (other.getDtoId() != null)
                return false;
        } else if (!dtoId.equals(other.getDtoId()))
            return false;
        return true;
    }
}
