package fr.inra.agrosyst.api.services.itk;

/*
 * #%L
 * Agrosyst :: API
 * $Id: Itk.java 2936 2014-01-28 09:05:37Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/itk/Itk.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Function;

import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.entities.referential.RefStadeEDI;
import fr.inra.agrosyst.api.services.practiced.RefStadeEdiDto;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class Itk {

    public static final BioAgressorType[] TREATMENT_TARGET_CATEGORIES = {
            BioAgressorType.ADVENTICE, BioAgressorType.GENERIQUE, BioAgressorType.MALADIE,
            BioAgressorType.PLANTE_PARASITE, BioAgressorType.PLANTES_ENVAHISSANTES_ORIGINE_EXOTIQUE,
            BioAgressorType.RAVAGEUR, BioAgressorType.VIRUS};

    public static final Function<RefStadeEDI, RefStadeEdiDto> STADE_EDI_TO_DTO = new Function<RefStadeEDI, RefStadeEdiDto>() {
        @Override
        public RefStadeEdiDto apply(RefStadeEDI refStadeEDI) {
            RefStadeEdiDto result = null;
            if (refStadeEDI != null) {
                String label = refStadeEDI.getAee().substring(6) + " - " + refStadeEDI.getColonne2();

                result = new RefStadeEdiDto();
                result.setTopiaId(refStadeEDI.getTopiaId());
                result.setLabel(label);
            }
            return result;
        }
    };

}
