package fr.inra.agrosyst.api.services.input;

/*
 * #%L
 * Agrosyst :: API
 * $Id: InputService.java 4972 2015-06-09 13:14:05Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/input/InputService.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractInput;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.api.services.effective.EffectiveInterventionDto;
import fr.inra.agrosyst.api.services.practiced.DuplicateCropCyclesContext;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author David Cossé
 */
public interface InputService extends AgrosystService {

    void updateInterventionInputs(
            PracticedIntervention practicedIntervention,
            EffectiveIntervention effectiveIntervention,
            List<AbstractInput> inputs,
            Map<String, AbstractAction> actions);

    void createInterventionInputs(
            PracticedIntervention practicedIntervention,
            EffectiveIntervention effectiveIntervention,
            List<AbstractInput> inputs,
            Map<String, AbstractAction> actions);


    void deleteInputForActions(Collection<AbstractAction> actions);

    /**
     * Duplicate practiced intervention or effective intervention actions and associate them with
     * previously duplicated actions cache map.
     *
     * @param duplicateContext duplicate context
     * @param practicedIntervention practiced intervention
     * @param effectiveIntervention effective intervention
     */
    void duplicateInputs(DuplicateCropCyclesContext duplicateContext, PracticedIntervention practicedIntervention,
                         EffectiveIntervention effectiveIntervention);

    AbstractInput getDuplicatedAbstractInput(Map<AbstractAction, AbstractAction> actionsToDuplicatedActions, AbstractInput input);

    void migrateInputSpeciesToTargetedSpecies(EffectiveInterventionDto interventionDto);
}
