package fr.inra.agrosyst.api.services.history;

/*
 * #%L
 * Agrosyst :: API
 * $Id: MessageService.java 4440 2014-10-16 17:25:26Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/history/MessageService.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.history.Message;
import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.api.services.ResultList;

import java.util.Date;
import java.util.List;

/**
 * Created by davidcosse on 14/10/14.
 */
public interface MessageService extends AgrosystService {

    void publishMessage(String title, String content);

    ResultList<Message> getFilteredMessages(MessageFilter filter);

    /**
     *
     * @param fromDate if null, it return all messages
     * @return
     */
    List<Message> getMessagesFromDate(Date fromDate);

    Date getLastMessageDate();
}
