package fr.inra.agrosyst.api.services.growingplan;

/*
 * #%L
 * Agrosyst :: API
 * $Id: GrowingPlanDto.java 3963 2014-04-02 09:42:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/growingplan/GrowingPlanDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;
import java.util.List;

import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.services.domain.DomainDto;
import fr.inra.agrosyst.api.services.users.UserDto;

/**
 * @author Arnaud Thimel (Code Lutin)
 */
public class GrowingPlanDto implements Serializable {

    private static final long serialVersionUID = -5282907088845136913L;

    protected String topiaId;
    protected String code;
    protected String name;
    protected DomainDto domain;
    protected TypeDEPHY type;
    protected boolean active;

    protected List<UserDto> responsibles;

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DomainDto getDomain() {
        return domain;
    }

    public void setDomain(DomainDto domain) {
        this.domain = domain;
    }

    public TypeDEPHY getType() {
        return type;
    }

    public void setType(TypeDEPHY type) {
        this.type = type;
    }

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public List<UserDto> getResponsibles() {
        return responsibles;
    }

    public void setResponsibles(List<UserDto> responsibles) {
        this.responsibles = responsibles;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((topiaId == null) ? 0 : topiaId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        GrowingPlanDto other = (GrowingPlanDto) obj;
        if (topiaId == null) {
            if (other.topiaId != null)
                return false;
        } else if (!topiaId.equals(other.topiaId))
            return false;
        return true;
    }
}
