package fr.inra.agrosyst.api.services.generic;

/*
 * #%L
 * Agrosyst :: API
 * $Id: GenericEntityService.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/generic/GenericEntityService.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.api.services.ResultList;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public interface GenericEntityService extends AgrosystService {

    ResultList<?> listEntities(Class<?> klass, GenericFilter filter);
    ResultList<?> listEntitiesFromString(String className, GenericFilter filter);

    Map<String, Long> countEntities(Class<?>... classes);
    Map<String, Long> countEntitiesFromString(List<String> classesList);

    List<String> getProperties(Class<?> klass);
    List<String> getPropertiesFromString(String className);

    void unactivateEntities(Class<?> klass, List<String> entityIds, boolean activate);
    void unactivateEntitiesFromString(String className, List<String> entityIds, boolean activate);

}
