package fr.inra.agrosyst.api.services.effective;

/*
 * #%L
 * Agrosyst :: API
 * $Id: EffectiveSeasonalCropCycleDto.java 4878 2015-04-02 20:20:30Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/effective/EffectiveSeasonalCropCycleDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycleImpl;

import java.util.List;

public class EffectiveSeasonalCropCycleDto extends EffectiveSeasonalCropCycleImpl {

    /** serialVersionUID. */
    private static final long serialVersionUID = 2868821925798641980L;

    protected List<EffectiveCropCycleConnectionDto> connectionDtos;
    
    protected List<EffectiveCropCycleNodeDto> nodeDtos;

    public List<EffectiveCropCycleConnectionDto> getConnectionDtos() {
        return connectionDtos;
    }

    public void setConnectionDtos(List<EffectiveCropCycleConnectionDto> connectionDtos) {
        this.connectionDtos = connectionDtos;
    }

    public void addConnectionDto(EffectiveCropCycleConnectionDto connectionDto) {
        if (connectionDtos == null) {
            connectionDtos = Lists.newArrayList();
        }
        connectionDtos.add(connectionDto);
    }

    public List<EffectiveCropCycleNodeDto> getNodeDtos() {
        return nodeDtos;
    }

    public void addNodeDto(EffectiveCropCycleNodeDto nodeDto) {
        if (nodeDtos == null) {
            nodeDtos = Lists.newArrayList();
        }
        nodeDtos.add(nodeDto);
    }

    public void setNodeDtos(List<EffectiveCropCycleNodeDto> nodeDtos) {
        this.nodeDtos = nodeDtos;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((topiaId == null) ? 0 : topiaId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        EffectiveSeasonalCropCycleDto other = (EffectiveSeasonalCropCycleDto) obj;
        if (topiaId == null) {
            if (other.topiaId != null)
                return false;
        } else if (!topiaId.equals(other.topiaId))
            return false;
        return true;
    }
}
