package fr.inra.agrosyst.api.services.effective;

/*
 * #%L
 * Agrosyst :: API
 * $Id: EffectivePerennialCropCycleDto.java 4876 2015-04-01 19:30:31Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/effective/EffectivePerennialCropCycleDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycleImpl;

import java.util.List;

public class EffectivePerennialCropCycleDto extends EffectivePerennialCropCycleImpl {

    /** serialVersionUID. */
    private static final long serialVersionUID = -96750496008680917L;

    protected String croppingPlanEntryId;
    protected String croppingPlanEntryName;

    protected String orientationId;
    protected String orientationLabel;

    protected List<EffectiveCropCycleSpeciesDto> speciesDtos;

    protected List<EffectiveCropCyclePhaseDto> phaseDtos;

    public String getCroppingPlanEntryName() {
        return croppingPlanEntryName;
    }

    public void setCroppingPlanEntryName(String croppingPlanEntryName) {
        this.croppingPlanEntryName = croppingPlanEntryName;
    }

    public String getOrientationLabel() {
        return orientationLabel;
    }

    public void setOrientationLabel(String orientationLabel) {
        this.orientationLabel = orientationLabel;
    }

    public String getCroppingPlanEntryId() {
        return croppingPlanEntryId;
    }

    public void setCroppingPlanEntryId(String croppingPlanEntryId) {
        this.croppingPlanEntryId = croppingPlanEntryId;
    }

    public String getOrientationId() {
        return orientationId;
    }

    public void setOrientationId(String orientationId) {
        this.orientationId = orientationId;
    }

    public List<EffectiveCropCycleSpeciesDto> getSpeciesDtos() {
        return speciesDtos;
    }

    public void setSpeciesDtos(List<EffectiveCropCycleSpeciesDto> speciesDtos) {
        this.speciesDtos = speciesDtos;
    }

    public void addSpeciesDto(EffectiveCropCycleSpeciesDto speciesDto) {
        if (speciesDtos == null) {
            speciesDtos = Lists.newArrayList();
        }
        speciesDtos.add(speciesDto);
    }

    public List<EffectiveCropCyclePhaseDto> getPhaseDtos() {
        return phaseDtos;
    }

    public void setPhaseDtos(List<EffectiveCropCyclePhaseDto> phaseDtos) {
        this.phaseDtos = phaseDtos;
    }

    public void addPhase(EffectiveCropCyclePhaseDto phaseDto) {
        if (phaseDtos == null) {
            phaseDtos = Lists.newArrayList();
        }
        phaseDtos.add(phaseDto);
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((topiaId == null) ? 0 : topiaId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        EffectivePerennialCropCycleDto other = (EffectivePerennialCropCycleDto) obj;
        if (topiaId == null) {
            if (other.topiaId != null)
                return false;
        } else if (!topiaId.equals(other.topiaId))
            return false;
        return true;
    }
}
