package fr.inra.agrosyst.api.services.effective;

/*
 * #%L
 * Agrosyst :: API
 * $Id: EffectiveInterventionDto.java 4890 2015-04-13 16:15:55Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/effective/EffectiveInterventionDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractInput;
import fr.inra.agrosyst.api.entities.effective.EffectiveInterventionImpl;
import fr.inra.agrosyst.api.services.itk.SpeciesStadeDto;

import java.util.Collection;
import java.util.List;
import java.util.Set;

public class EffectiveInterventionDto extends EffectiveInterventionImpl {

    private static final long serialVersionUID = -5697095213776953671L;

    protected String domainId;

    protected Set<String> toolsCouplingCodes;

    protected Collection<AbstractAction> actions;

    protected List<AbstractInput> inputs;

    protected List<SpeciesStadeDto> speciesStadesDtos;

    public String getDomainId() {
        return domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public Set<String> getToolsCouplingCodes() {
        return toolsCouplingCodes;
    }

    public void setToolsCouplingCodes(Set<String> toolsCouplingCodes) {
        this.toolsCouplingCodes = toolsCouplingCodes;
    }

    public Collection<AbstractAction> getActions() {
        return actions;
    }

    public void setActions(Collection<AbstractAction> actions) {
        this.actions = actions;
    }

    public List<AbstractInput> getInputs() {
        return inputs;
    }

    public void setInputs(List<AbstractInput> inputs) {
        this.inputs = inputs;
    }

    public List<SpeciesStadeDto> getSpeciesStadesDtos() {
        return speciesStadesDtos;
    }

    public void setSpeciesStadesDtos(List<SpeciesStadeDto> speciesStadesDtos) {
        this.speciesStadesDtos = speciesStadesDtos;
    }

    public void addToolsCouplingCodes(String toolsCouplingCode) {
        if (toolsCouplingCodes == null) {
            toolsCouplingCodes = Sets.newHashSet();
        }
        toolsCouplingCodes.add(toolsCouplingCode);
    }

    public void addSpeciesStadesDto(SpeciesStadeDto speciesStadeDto) {
        if (speciesStadesDtos == null) {
            speciesStadesDtos = Lists.newArrayList();
        }
        speciesStadesDtos.add(speciesStadeDto);
    }

    public void addAction(AbstractAction abstractAction) {
        if (actions == null) {
            actions = Lists.newArrayList();
        }
        actions.add(abstractAction);
    }

    public void addInput(AbstractInput input) {
        if (inputs == null) {
            inputs = Lists.newArrayList();
        }
        inputs.add(input);
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((topiaId == null) ? 0 : topiaId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        EffectiveInterventionDto other = (EffectiveInterventionDto) obj;
        if (topiaId == null) {
            if (other.topiaId != null)
                return false;
        } else if (!topiaId.equals(other.topiaId))
            return false;
        return true;
    }
}
