package fr.inra.agrosyst.api.services.effective;

/*
 * #%L
 * Agrosyst :: API
 * $Id: EffectiveCropCycles.java 4906 2015-04-24 09:00:23Z eancelet $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/effective/EffectiveCropCycles.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Set;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import fr.inra.agrosyst.api.entities.CroppingEntryType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnection;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNode;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhase;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleSpecies;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycle;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.effective.EffectiveSpeciesStade;
import fr.inra.agrosyst.api.entities.referential.RefEspece;
import fr.inra.agrosyst.api.services.domain.Equipments;
import fr.inra.agrosyst.api.services.itk.Itk;
import fr.inra.agrosyst.api.services.itk.SpeciesStadeDto;

public class EffectiveCropCycles {

    public static final Function<EffectiveCropCycleConnection, EffectiveCropCycleConnectionDto> CROP_CYCLE_CONNECTION_TO_DTO = new Function<EffectiveCropCycleConnection, EffectiveCropCycleConnectionDto>() {
        @Override
        public EffectiveCropCycleConnectionDto apply(EffectiveCropCycleConnection input) {
            EffectiveCropCycleConnectionDto result = new EffectiveCropCycleConnectionDto();
            // can be null for connection to BEFORE NODE
            if (input.getSource() != null) {
                result.setSourceId(Entities.ESCAPE_TOPIA_ID.apply(input.getSource().getTopiaId()));
            }
            result.setTargetId(Entities.ESCAPE_TOPIA_ID.apply(input.getTarget().getTopiaId()));
            String label = "";
            String intermediateCroppingPlanEntryName = "";
            if (input.getIntermediateCroppingPlanEntry() != null) {
                result.setIntermediateCroppingPlanEntryId(input.getIntermediateCroppingPlanEntry().getTopiaId());
                label += "<b>CI</b><span class='hover-infos'>" + input.getIntermediateCroppingPlanEntry().getName() + "</span>";
                intermediateCroppingPlanEntryName = input.getIntermediateCroppingPlanEntry().getName();
            }
            result.setLabel(label);
            result.setIntermediateCroppingPlanEntryName(intermediateCroppingPlanEntryName);
            result.setEdaplosIssuerId(input.getEdaplosIssuerId());
            return result;
        }
    };

    public static final Function<EffectiveCropCycleNode, EffectiveCropCycleNodeDto> CROP_CYCLE_NODE_TO_DTO = new Function<EffectiveCropCycleNode, EffectiveCropCycleNodeDto>() {
        @Override
        public EffectiveCropCycleNodeDto apply(EffectiveCropCycleNode input) {
            EffectiveCropCycleNodeDto result = new EffectiveCropCycleNodeDto();
            result.setNodeId(Entities.ESCAPE_TOPIA_ID.apply(input.getTopiaId()));
            result.setX(input.getRank());
            result.setEdaplosIssuerId(input.getEdaplosIssuerId());
            if (input.getCroppingPlanEntry() != null) {
                result.setCroppingPlanEntryId(input.getCroppingPlanEntry().getTopiaId());
                result.setLabel(input.getCroppingPlanEntry().getName());
            }
            return result;
        }
    };

    public static final Function<EffectivePerennialCropCycle, EffectivePerennialCropCycleDto> PERENNIAL_CROP_CYCLE_TO_DTO = new Function<EffectivePerennialCropCycle, EffectivePerennialCropCycleDto>() {
        @Override
        public EffectivePerennialCropCycleDto apply(EffectivePerennialCropCycle input) {
            EffectivePerennialCropCycleDto result = new EffectivePerennialCropCycleDto();
            result.setTopiaId(input.getTopiaId());
            result.setPlantingYear(input.getPlantingYear());
            result.setPlantingDensity(input.getPlantingDensity());
            result.setPlantingInterFurrow(input.getPlantingInterFurrow());
            result.setPlantingSpacing(input.getPlantingSpacing());
            result.setPlantingDeathRate(input.getPlantingDeathRate());
            result.setPlantingDeathRateMeasureYear(input.getPlantingDeathRateMeasureYear());
            result.setPollinator(input.isPollinator());
            result.setPollinatorPercent(input.getPollinatorPercent());
            result.setPollinatorSpreadMode(input.getPollinatorSpreadMode());
            result.setWeedType(input.getWeedType());
            result.setVineFrutalForm(input.getVineFrutalForm());
            result.setOrchardFrutalForm(input.getOrchardFrutalForm());
            result.setOtherCharacteristics(input.getOtherCharacteristics());
            result.setCroppingPlanEntryId(input.getCroppingPlanEntry().getTopiaId());
            result.setCroppingPlanEntryName(input.getCroppingPlanEntry().getName());
            result.setFoliageHeight(input.getFoliageHeight());
            result.setFoliageThickness(input.getFoliageThickness());
            result.setEdaplosIssuerId(input.getEdaplosIssuerId());
            if (input.getOrientation() != null) {
                result.setOrientationId(input.getOrientation().getTopiaId());
                result.setOrientationLabel(input.getOrientation().getReference_label());
            }
            return result;
        }
    };

    public static final Function<EffectiveSeasonalCropCycle, EffectiveSeasonalCropCycleDto> SEASONNAL_CROP_CYCLE_TO_DTO = new Function<EffectiveSeasonalCropCycle, EffectiveSeasonalCropCycleDto>() {
        @Override
        public EffectiveSeasonalCropCycleDto apply(EffectiveSeasonalCropCycle input) {
            EffectiveSeasonalCropCycleDto result = new EffectiveSeasonalCropCycleDto();
            result.setTopiaId(input.getTopiaId());
            return result;
        }
    };

    public static final Function<EffectiveCropCyclePhase, EffectiveCropCyclePhaseDto> CROP_CYCLE_PHASE_TO_DTO = new Function<EffectiveCropCyclePhase, EffectiveCropCyclePhaseDto>() {
        @Override
        public EffectiveCropCyclePhaseDto apply(EffectiveCropCyclePhase input) {
            EffectiveCropCyclePhaseDto result = new EffectiveCropCyclePhaseDto();
            result.setTopiaId(input.getTopiaId());
            result.setDuration(input.getDuration());
            result.setType(input.getType());
            return result;
        }
    };

    public static final Function<EffectiveIntervention, EffectiveInterventionDto> INTERVENTION_TO_DTO = new Function<EffectiveIntervention, EffectiveInterventionDto>() {
        @Override
        public EffectiveInterventionDto apply(EffectiveIntervention input) {
            EffectiveInterventionDto result = new EffectiveInterventionDto();
            result.setTopiaId(input.getTopiaId());
            result.setName(input.getName());
            result.setComment(input.getComment());
            result.setStartInterventionDate(input.getStartInterventionDate());
            result.setEndInterventionDate(input.getEndInterventionDate());
            result.setIntermediateCrop(input.isIntermediateCrop());
            result.setSpatialFrequency(input.getSpatialFrequency());
            result.setTillageDepth(input.getTillageDepth());
            result.setOtherToolSettings(input.getOtherToolSettings());
            result.setWorkRate(input.getWorkRate());
            result.setProgressionSpeed(input.getProgressionSpeed());
            result.setInvolvedPeopleCount(input.getInvolvedPeopleCount());
            result.setTransitCount(input.getTransitCount());
            result.setType(input.getType());
            result.setEdaplosIssuerId(input.getEdaplosIssuerId());
            result.setWorkRateUnit(input.getWorkRateUnit());
            result.setTransitVolume(input.getTransitVolume());
            result.setTransitVolumeUnit(input.getTransitVolumeUnit());
            result.setNbBalls(input.getNbBalls());

            List<SpeciesStadeDto> stadeDtos = null;
            if (input.getSpeciesStades() != null) {
                stadeDtos = Lists.newArrayList(Iterables.transform(input.getSpeciesStades(), SPECIES_STADE_TO_DTO));
            }
            result.setSpeciesStadesDtos(stadeDtos);

            Set<String> toolCouplingCodes = null;
            if (input.getToolCouplings() != null) {
                toolCouplingCodes = Sets.newLinkedHashSet(Iterables.transform(input.getToolCouplings(), Equipments.GET_TOOLS_COUPLING_CODE));
            }
            result.setToolsCouplingCodes(toolCouplingCodes);

            return result;
        }
    };

    public static final Function<EffectiveSpeciesStade, SpeciesStadeDto> SPECIES_STADE_TO_DTO = new Function<EffectiveSpeciesStade, SpeciesStadeDto>() {
        @Override
        public SpeciesStadeDto apply(EffectiveSpeciesStade input) {
            SpeciesStadeDto result = new SpeciesStadeDto();
            result.setTopiaId(input.getTopiaId());

            if (input.getCroppingPlanSpecies() != null) {
                CroppingPlanSpecies species = input.getCroppingPlanSpecies();
                result.setSpeciesCode(species.getCode());
                RefEspece espece = species.getSpecies();
                String speciesName = espece != null ? species.getSpecies().getLibelle_espece_botanique() : "";
                speciesName += species.getVariety() != null ? " (" + species.getVariety().getLabel() + ")" : "";
                result.setSpeciesName(speciesName);
            }
            result.setStadeMin(Itk.STADE_EDI_TO_DTO.apply(input.getMinStade()));
            result.setStadeMax(Itk.STADE_EDI_TO_DTO.apply(input.getMaxStade()));
            return result;
        }
    };

    public static final Function<CroppingPlanEntry, EffectiveCropCycleModelDto> CROPPING_PLAN_ENTRY_TO_DTO = new Function<CroppingPlanEntry, EffectiveCropCycleModelDto>() {
        @Override
        public EffectiveCropCycleModelDto apply(CroppingPlanEntry input) {
            EffectiveCropCycleModelDto result = new EffectiveCropCycleModelDto();
            result.setCroppingPlanEntryId(input.getTopiaId());
            result.setLabel(input.getName());
            result.setIntermediate(input.getType() == CroppingEntryType.INTERMEDIATE);
            return result;
        }
    };

    public static final Function<EffectiveCropCycleSpecies, String> GET_CROP_CYCLE_PERENNIAL_SPECIES_CODE = new Function<EffectiveCropCycleSpecies, String>() {
        @Override
        public String apply(EffectiveCropCycleSpecies input) {
            return input.getCroppingPlanSpecies().getCode();
        }
    };

}
