package fr.inra.agrosyst.api.services.effective;

/*
 * #%L
 * Agrosyst :: API
 * $Id: EffectiveCropCycleSpeciesDto.java 3963 2014-04-02 09:42:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/effective/EffectiveCropCycleSpeciesDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Date;

import fr.inra.agrosyst.api.services.domain.CroppingPlanSpeciesDto;
import fr.inra.agrosyst.api.services.practiced.CropCycleGraftDto;

public class EffectiveCropCycleSpeciesDto extends CroppingPlanSpeciesDto {

    private static final long serialVersionUID = -3406917281269769835L;

    protected boolean plantsCertified;
    protected Date overGraftDate;

    protected String croppingPlanSpeciesId;

    protected CropCycleGraftDto graftSupport;
    protected CropCycleGraftDto graftClone;

    public EffectiveCropCycleSpeciesDto() {
    }

    public EffectiveCropCycleSpeciesDto(CroppingPlanSpeciesDto parent) {
        this.croppingPlanSpeciesId = parent.getTopiaId();
        this.code = parent.getCode();

        this.speciesId = parent.getSpeciesId();
        this.speciesEspece = parent.getSpeciesEspece();
        this.speciesQualifiant = parent.getSpeciesQualifiant();
        this.speciesTypeSaisonnier = parent.getSpeciesTypeSaisonnier();
        this.speciesDestination = parent.getSpeciesDestination();

        this.varietyId = parent.getVarietyId();
        this.varietyLibelle = parent.getVarietyLibelle();
        this.profil_vegetatif_BBCH = parent.getProfil_vegetatif_BBCH();
    }

    public Date getOverGraftDate() {
        return overGraftDate;
    }

    public void setOverGraftDate(Date overGraftDate) {
        this.overGraftDate = overGraftDate;
    }

    public boolean isPlantsCertified() {
        return plantsCertified;
    }

    public void setPlantsCertified(boolean plantsCertified) {
        this.plantsCertified = plantsCertified;
    }

    public String getCroppingPlanSpeciesId() {
        return croppingPlanSpeciesId;
    }

    public void setCroppingPlanSpeciesId(String croppingPlanSpeciesId) {
        this.croppingPlanSpeciesId = croppingPlanSpeciesId;
    }

    public CropCycleGraftDto getGraftSupport() {
        return graftSupport;
    }

    public void setGraftSupport(CropCycleGraftDto graftSupport) {
        this.graftSupport = graftSupport;
    }

    public CropCycleGraftDto getGraftClone() {
        return graftClone;
    }

    public void setGraftClone(CropCycleGraftDto graftClone) {
        this.graftClone = graftClone;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((croppingPlanSpeciesId == null) ? 0 : croppingPlanSpeciesId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        EffectiveCropCycleSpeciesDto other = (EffectiveCropCycleSpeciesDto) obj;
        if (topiaId == null) {
            if (other.topiaId != null)
                return false;
        } else if (!topiaId.equals(other.topiaId))
            return false;
        return true;
    }
}
