package fr.inra.agrosyst.api.services.effective;

/*
 * #%L
 * Agrosyst :: API
 * $Id: EffectiveCropCyclePhaseDto.java 4876 2015-04-01 19:30:31Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/effective/EffectiveCropCyclePhaseDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhaseImpl;

import java.util.List;

public class EffectiveCropCyclePhaseDto extends EffectiveCropCyclePhaseImpl {

    /** serialVersionUID. */
    private static final long serialVersionUID = 8803025829570156052L;

    protected List<EffectiveInterventionDto> interventions;

    public List<EffectiveInterventionDto> getInterventions() {
        return interventions;
    }

    public void setInterventions(
            List<EffectiveInterventionDto> interventions) {
        this.interventions = interventions;
    }

    public void addIntervention(EffectiveInterventionDto interventionDto) {
        if (interventions == null) {
            interventions = Lists.newArrayList();
        }
        interventions.add(interventionDto);
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((topiaId == null) ? 0 : topiaId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        EffectiveCropCyclePhaseDto other = (EffectiveCropCyclePhaseDto) obj;
        if (topiaId == null) {
            if (other.topiaId != null)
                return false;
        } else if (!topiaId.equals(other.topiaId))
            return false;
        return true;
    }
}
