package fr.inra.agrosyst.api.services.effective;

/*
 * #%L
 * Agrosyst :: API
 * $Id: EffectiveCropCycleNodeDto.java 4890 2015-04-13 16:15:55Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/effective/EffectiveCropCycleNodeDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNodeImpl;

import java.util.List;

public class EffectiveCropCycleNodeDto extends EffectiveCropCycleNodeImpl {

    public static final String NODE_BEFORE_ID = "NODE_BEFORE";

    /** serialVersionUID. */
    private static final long serialVersionUID = 8499851869524044733L;

    protected String nodeId;

    protected int x;

    protected String croppingPlanEntryId;

    protected String label;

    /** Type de noeud (si before node, ce n'est pas un vrai noeud). */
    protected String type;

    protected List<EffectiveInterventionDto> interventions;

    public int getX() {
        return x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public String getNodeId() {
        return nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getCroppingPlanEntryId() {
        return croppingPlanEntryId;
    }

    public void setCroppingPlanEntryId(String croppingPlanEntryId) {
        this.croppingPlanEntryId = croppingPlanEntryId;
    }

    public List<EffectiveInterventionDto> getInterventions() {
        return interventions;
    }

    public void setInterventions(
            List<EffectiveInterventionDto> interventions) {
        this.interventions = interventions;
    }

    public void addIntervention(EffectiveInterventionDto interventionDto) {
        if (interventions == null) {
            interventions = Lists.newArrayList();
        }
        interventions.add(interventionDto);
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
