package fr.inra.agrosyst.api.services.effective;

/*
 * #%L
 * Agrosyst :: API
 * $Id: EffectiveCropCycleModelDto.java 3963 2014-04-02 09:42:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/effective/EffectiveCropCycleModelDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;

/**
 * Un model représente un model de culture pouvant servir à:
 * - creer un noeud dans un cycle pluriannuel de culture assolées
 * - choisir une culture dans un cycle pluriannuel de culture pérennes.
 * 
 * Cela permet de définir une cuture à un rang donné.
 * 
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class EffectiveCropCycleModelDto implements Serializable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 5126472555940965611L;

    protected String croppingPlanEntryId;
    protected String label;
    protected boolean intermediate;

    public String getCroppingPlanEntryId() {
        return croppingPlanEntryId;
    }

    public void setCroppingPlanEntryId(String croppingPlanEntryId) {
        this.croppingPlanEntryId = croppingPlanEntryId;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isIntermediate() {
        return intermediate;
    }

    public void setIntermediate(boolean intermediate) {
        this.intermediate = intermediate;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((croppingPlanEntryId == null) ? 0 : croppingPlanEntryId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        EffectiveCropCycleModelDto other = (EffectiveCropCycleModelDto) obj;
        if (croppingPlanEntryId == null) {
            if (other.croppingPlanEntryId != null)
                return false;
        } else if (!croppingPlanEntryId.equals(other.croppingPlanEntryId))
            return false;
        return true;
    }
}
