package fr.inra.agrosyst.api.services.edaplos;

/*
 * #%L
 * Agrosyst :: API
 * $Id: EdaplosSownAgriculturalCropDto.java 4629 2014-12-10 09:18:38Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/edaplos/EdaplosSownAgriculturalCropDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;
import java.util.List;

import com.google.common.collect.Lists;

/**
 * Représente une espèce au sens Agrosyst 
 * 
 * @author eancelet
 *
 */


public class EdaplosSownAgriculturalCropDto implements Serializable {
    
    private static final long serialVersionUID = -2180171788221654707L;

    protected EdaplosParsingStatus edaplosParsingStatus;
    protected List<String> sownAgriculturalCropInfoMessages;
    protected List<String> sownAgriculturalCropErrorMessages;
    
    protected String botanicalSpecies; // Espèce
    protected String supplementaryBotanicalSpecies; // Qualifiant
    protected String sowingPeriod; // Type saisonnier
    // Destination est à attribuer au hasard
    protected String description; // à concaténer avec le commentaire sur la culture
    
    public EdaplosSownAgriculturalCropDto(){
        this.sownAgriculturalCropInfoMessages = Lists.newArrayList();
        this.sownAgriculturalCropErrorMessages = Lists.newArrayList();        
    }

    public EdaplosParsingStatus getEdaplosParsingStatus() {
        return edaplosParsingStatus;
    }

    public void setEdaplosParsingStatus(EdaplosParsingStatus edaplosParsingStatus) {
        this.edaplosParsingStatus = edaplosParsingStatus;
    }

    public List<String> getSownAgriculturalCropInfoMessages() {
        return sownAgriculturalCropInfoMessages;
    }

    public void addSownAgriculturalCropInfoMessage(String content) {
        this.sownAgriculturalCropInfoMessages.add(content);
    }

    public List<String> getSownAgriculturalCropErrorMessages() {
        return sownAgriculturalCropErrorMessages;
    }

    public void addSownAgriculturalCropErrorMessage(String content) {
        this.sownAgriculturalCropErrorMessages.add(content);
    }

    public String getBotanicalSpecies() {
        return botanicalSpecies;
    }

    public void setBotanicalSpecies(String botanicalSpecies) {
        this.botanicalSpecies = botanicalSpecies;
    }

    public String getSupplementaryBotanicalSpecies() {
        return supplementaryBotanicalSpecies;
    }

    public void setSupplementaryBotanicalSpecies(String supplementaryBotanicalSpecies) {
        this.supplementaryBotanicalSpecies = supplementaryBotanicalSpecies;
    }

    public String getSowingPeriod() {
        return sowingPeriod;
    }

    public void setSowingPeriod(String sowingPeriod) {
        this.sowingPeriod = sowingPeriod;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
    
    
    
    
}
