package fr.inra.agrosyst.api.services.edaplos;

/*
 * #%L
 * Agrosyst :: API
 * $Id: EdaplosService.java 4997 2015-06-18 09:12:01Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/edaplos/EdaplosService.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */



import java.io.InputStream;
import java.util.List;
import java.util.Map;

import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.api.services.referential.ImportResult;

/**
 * Edaplos service.
 * To persist eDaplos datas
 *
 * @author eancelet@orleans.inra.fr
 */

public interface EdaplosService extends AgrosystService {

    /**
     * return the result of Edaplos parsing
     * @param inputStream the Edaplos file
     * @return the result of Edaplos parsing
     */
    List<EdaplosParsingResult> validEdaplosData(InputStream inputStream);
    
    /**
     * Import parse data
     * @param edaplosParsingResults parsing data
     * @return import result as class name, result
     */
    
    Map<Class, ImportResult> importEdaplos(List<EdaplosParsingResult> edaplosParsingResults);


    
    
    
}
