package fr.inra.agrosyst.api.services.edaplos;

/*
 * #%L
 * Agrosyst :: API
 * $Id: EdaplosPlotDto.java 4826 2015-03-06 15:20:37Z eancelet $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/edaplos/EdaplosPlotDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;

import fr.inra.agrosyst.api.entities.BufferStrip;
import fr.inra.agrosyst.api.entities.MaxSlope;
import fr.inra.agrosyst.api.entities.WaterFlowDistance;
import fr.inra.agrosyst.api.services.effective.EffectivePerennialCropCycleDto;
import fr.inra.agrosyst.api.services.effective.EffectiveSeasonalCropCycleDto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EdaplosPlotDto implements Serializable {

    private static final long serialVersionUID = -194412415157434451L;

    protected List<String> plotInfoMessages;
    protected List<String> plotErrorMessages;
    protected String status;

    /**
     * required field for plot
     */
    // TODO DCossé 22/10/14 ces champs sont actuellement manquant
    protected String plotName;
    protected WaterFlowDistance waterFlowDistance;
    protected BufferStrip bufferStrip;
    protected MaxSlope maxSlope;
    
    protected String topiaId;
    protected String issuerId;
    protected String area;
    protected String type;
    protected String location;
        
    // Soil Occupations
    
    protected List<String> soilOccInfoMessages;
    protected List<String> soilOccErrorMessages;
    
    protected EffectiveSeasonalCropCycleDto seasonalCycleDto;
    protected List<EffectivePerennialCropCycleDto> perennialCycleDtos;
    

    public EdaplosPlotDto() {
        plotInfoMessages = Lists.newArrayList();
        plotErrorMessages = Lists.newArrayList();
        soilOccInfoMessages = Lists.newArrayList();
        soilOccErrorMessages = Lists.newArrayList();
        this.perennialCycleDtos = new ArrayList<EffectivePerennialCropCycleDto>();        
    }

    protected EdaplosParsingStatus edaplosParsingStatus;

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getIssuerId() {
        return issuerId;
    }

    public void setIssuerId(String issuerId) {
        this.issuerId = issuerId;
    }

    public List<String> getPlotInfoMessages() {
        return plotInfoMessages;
    }

    public List<String> getPlotErrorMessages() {
        return plotErrorMessages;
    }

    public void addPlotInfoMessage(String content) {
        this.plotInfoMessages.add(content);
    }

    public EdaplosParsingStatus getEdaplosParsingStatus() {
        return edaplosParsingStatus;
    }

    public void addPlotErrorMessage(String content) {
        this.edaplosParsingStatus = EdaplosParsingStatus.FAIL;
        this.plotErrorMessages.add(content);
    }

    public String getPlotName() {
        return plotName;
    }

    public void setPlotName(String plotName) {
        this.plotName = plotName;
    }

    public WaterFlowDistance getWaterFlowDistance() {
        return waterFlowDistance;
    }

    public void setWaterFlowDistance(WaterFlowDistance waterFlowDistance) {
        this.waterFlowDistance = waterFlowDistance;
    }

    public BufferStrip getBufferStrip() {
        return bufferStrip;
    }

    public void setBufferStrip(BufferStrip bufferStrip) {
        this.bufferStrip = bufferStrip;
    }

    public MaxSlope getMaxSlope() {
        return maxSlope;
    }

    public void setMaxSlope(MaxSlope maxSlope) {
        this.maxSlope = maxSlope;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public List<String> getSoilOccInfoMessages() {
        return soilOccInfoMessages;
    }

    public void setSoilOccInfoMessages(List<String> soilOccInfoMessages) {
        this.soilOccInfoMessages = soilOccInfoMessages;
    }
    
    public void addSoilOccInfoMessage(String soilOccInfoMessage) {
        this.soilOccInfoMessages.add(soilOccInfoMessage);
    }

    public List<String> getSoilOccErrorMessages() {
        return soilOccErrorMessages;
    }

    public void setSoilOccErrorMessages(List<String> soilOccErrorMessages) {
        this.soilOccErrorMessages = soilOccErrorMessages;
    }
    
    public void addSoilOccErrorMessage(String soilOccErrorMessage) {
        this.soilOccErrorMessages.add(soilOccErrorMessage);
    }    

    public EffectiveSeasonalCropCycleDto getSeasonalCycleDto() {
        return seasonalCycleDto;
    }

    public void setSeasonalCycleDto(EffectiveSeasonalCropCycleDto seasonalCycleDto) {
        this.seasonalCycleDto = seasonalCycleDto;
    }

    public List<EffectivePerennialCropCycleDto> getPerennialCycleDtos() {
        return perennialCycleDtos;
    }

    public void setPerennialCycleDtos(List<EffectivePerennialCropCycleDto> perennialCycleDtos) {
        this.perennialCycleDtos = perennialCycleDtos;
    }



}
