package fr.inra.agrosyst.api.services.edaplos;

/*
 * #%L
 * Agrosyst :: API
 * $Id: EdaplosParsingResult.java 4454 2014-10-22 22:26:08Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/edaplos/EdaplosParsingResult.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;

import java.io.Serializable;
import java.util.List;


/**
 * @author eancelet@orleans.inra.fr
 */
public class EdaplosParsingResult implements Serializable {

    private static final long serialVersionUID = -2465365207118298415L;

    protected List<String> globalInfoMessages;
    protected List<String> globalErrorMessages;
    protected EdaplosParsingStatus edaplosParsingStatus;

    protected List<EdaplosDomainDto> domains;

    public EdaplosParsingResult() {
        edaplosParsingStatus = EdaplosParsingStatus.SUCCESS;
        globalInfoMessages = Lists.newArrayList();
        globalErrorMessages = Lists.newArrayList();
        domains = Lists.newArrayList();
    }

    public void addInfoMessage(String message) {
        globalInfoMessages.add(message);
    }

    public void addErrorMessage(String message) {
        this.setEdaplosParsingStatus(EdaplosParsingStatus.FAIL);
        globalErrorMessages.add(message);
    }

    public List<String> getGlobalInfoMessages() {
        return globalInfoMessages;
    }

    public List<String> getGlobalErrorMessages() {
        return globalErrorMessages;
    }

    public List<EdaplosDomainDto> getDomains() {
        return domains;
    }

    public void addDomain(EdaplosDomainDto domain) {
        if (domain.getEdaplosParsingStatus() == EdaplosParsingStatus.FAIL) {
            this.edaplosParsingStatus = EdaplosParsingStatus.FAIL;
        }
        this.domains.add(domain);
    }


    public EdaplosParsingStatus getEdaplosParsingStatus() {
        return edaplosParsingStatus;
    }

    public void setEdaplosParsingStatus(EdaplosParsingStatus edaplosParsingStatus) {
        this.edaplosParsingStatus = edaplosParsingStatus;
    }
}
