package fr.inra.agrosyst.api.services.edaplos;

/*
 * #%L
 * Agrosyst :: API
 * $Id: EdaplosDomainDto.java 4819 2015-03-03 16:51:28Z eancelet $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/edaplos/EdaplosDomainDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;

import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author eancelet@orleans.inra.fr
 */
public class EdaplosDomainDto implements Serializable {

    private static final long serialVersionUID = -7543867839403562927L;

    protected EdaplosDomainImportStatus status;
    protected List<String> domainInfoMessages;
    protected List<String> domainErrorMessages;

    protected String topiaId;
    protected String campaign;
    protected String name;
    protected String mainContact;
    protected String cityName;
    protected String postcodeCode;
    protected RefLocation location;

    protected String siret;
    protected List<EdaplosPlotDto> plots;
    
    protected List<CroppingPlanEntryDto> croppingPlanEntryDtos;

    public EdaplosDomainDto(){
        this.plots = new ArrayList<EdaplosPlotDto>();
        this.domainInfoMessages = Lists.newArrayList();
        this.domainErrorMessages = Lists.newArrayList();
        this.croppingPlanEntryDtos = Lists.newArrayList();
    }

    protected EdaplosParsingStatus edaplosParsingStatus;

    public String getCampaign() {
        return campaign;
    }

    public void setCampaign(String campaign) {
        this.campaign = campaign;
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public EdaplosDomainImportStatus getStatus() {
        return status;
    }

    public void setStatus(EdaplosDomainImportStatus status) {
        this.status = status;
    }

    public List<EdaplosPlotDto> getPlots() {
        return plots;
    }

    public List<String> getDomainInfoMessages() {
        return domainInfoMessages;
    }

    public List<String> getDomainErrorMessages() {
        return domainErrorMessages;
    }

    public void addInfoMessage(String message) {
        getDomainInfoMessages().add(message);
    }

    public void addErrorMessage(String message) {
        this.edaplosParsingStatus = EdaplosParsingStatus.FAIL;
        getDomainErrorMessages().add(message);
    }

    public EdaplosParsingStatus getEdaplosParsingStatus() {
        return edaplosParsingStatus;
    }

    public void addPlot(EdaplosPlotDto plot) {
        if (plot.getEdaplosParsingStatus() == EdaplosParsingStatus.FAIL) {
            this.edaplosParsingStatus = EdaplosParsingStatus.FAIL;
        }
        plots.add(plot);
    }

    public String getSiret() {
        return siret;
    }

    public void setSiret(String siret) {
        this.siret = siret;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMainContact() {
        return mainContact;
    }

    public void setMainContact(String mainContact) {
        this.mainContact = mainContact;
    }

    public String getCityName() {
        return cityName;
    }
    
    public void addCroppingPlanEntryDto(CroppingPlanEntryDto croppingPlanEntryDto) {
        if(this.croppingPlanEntryDtos == null) {
            this.croppingPlanEntryDtos = Lists.newArrayList();
        }
        this.croppingPlanEntryDtos.add(croppingPlanEntryDto);
    }    
    
    public void setCroppingPlanEntryDtos(List<CroppingPlanEntryDto> croppingPlanEntryDtos) {
        this.croppingPlanEntryDtos = croppingPlanEntryDtos;
    }

    public List<CroppingPlanEntryDto> getCroppingPlanEntryDtos() {
        return croppingPlanEntryDtos;
    }   

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getPostcodeCode() {
        return postcodeCode;
    }

    public void setPostcodeCode(String postcodeCode) {
        this.postcodeCode = postcodeCode;
    }

    public RefLocation getLocation() {
        return location;
    }

    public void setLocation(RefLocation location) {
        this.location = location;
    }

}
