package fr.inra.agrosyst.api.services.domain;

/*
 * #%L
 * Agrosyst :: API
 * $Id: ZoneDto.java 4612 2014-12-06 18:43:48Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/domain/ZoneDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;

/**
 * @author Arnaud Thimel (Code Lutin)
 */
public class ZoneDto implements Serializable {

    private static final long serialVersionUID = -8143068665059071399L;

    protected String topiaId;
    protected String code;
    protected String name;
    protected PlotDto plot;
    // to get Cropping Plan Entry name and intervention number associated to the zone 
    protected String croppingPlanInfo;

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PlotDto getPlot() {
        return plot;
    }

    public void setPlot(PlotDto plot) {
        this.plot = plot;
    }

    public String getCroppingPlanInfo() {
        return croppingPlanInfo;
    }

    public void setCroppingPlanInfo(String croppingPlanInfo) {
        this.croppingPlanInfo = croppingPlanInfo;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((topiaId == null) ? 0 : topiaId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ZoneDto other = (ZoneDto) obj;
        if (topiaId == null) {
            if (other.topiaId != null)
                return false;
        } else if (!topiaId.equals(other.topiaId))
            return false;
        return true;
    }

}
