package fr.inra.agrosyst.api.services.domain;

/*
 * #%L
 * Agrosyst :: API
 * $Id: ToolsCouplingDto.java 4235 2014-07-24 20:45:24Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/domain/ToolsCouplingDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;

import fr.inra.agrosyst.api.entities.MaterielTransportUnit;
import fr.inra.agrosyst.api.entities.MaterielWorkRateUnit;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;

/**
 * @author cosse
 */
public class ToolsCouplingDto implements Serializable {

    private static final long serialVersionUID = -6341638291682562472L;

    protected String topiaId;

    protected String code;

    protected String toolsCouplingName;

    protected String tractorId;

    protected String tractorKey;

    protected Set<String> equipementsIds;

    protected Set<String> equipementsKeys;

    protected Double flow;

    protected Integer workforce;

    protected String comment;

    protected Double workRate;

    protected MaterielWorkRateUnit workRateUnit;

    protected MaterielTransportUnit materielTransportUnit;

    protected boolean manualIntervention;

    protected Double transitVolume;

    protected Collection<RefInterventionAgrosystTravailEDI> mainsActions;

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getTractorId() {
        return tractorId;
    }

    public void setTractorId(String tractorId) {
        this.tractorId = tractorId;
    }

    public String getTractorKey() {
        return tractorKey;
    }

    public void setTractorKey(String tractorKey) {
        this.tractorKey = tractorKey;
    }

    public Set<String> getEquipementsIds() {
        return equipementsIds;
    }

    public void setEquipementsIds(Set<String> equipementsIds) {
        this.equipementsIds = equipementsIds;
    }

    public Set<String> getEquipementsKeys() {
        return equipementsKeys;
    }

    public void setEquipementsKeys(Set<String> equipementsKeys) {
        this.equipementsKeys = equipementsKeys;
    }

    public Double getFlow() {
        return flow;
    }

    public void setFlow(Double flow) {
        this.flow = flow;
    }

    public Integer getWorkforce() {
        return workforce;
    }

    public void setWorkforce(Integer workforce) {
        this.workforce = workforce;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getToolsCouplingName() {
        return toolsCouplingName;
    }

    public void setToolsCouplingName(String toolsCouplingName) {
        this.toolsCouplingName = toolsCouplingName;
    }

    public Collection<RefInterventionAgrosystTravailEDI> getMainsActions() {
        return mainsActions;
    }

    public void setMainsActions(Collection<RefInterventionAgrosystTravailEDI> mainsActions) {
        this.mainsActions = mainsActions;
    }

    public Double getWorkRate() {
        return workRate;
    }

    public void setWorkRate(Double workRate) {
        this.workRate = workRate;
    }

    public MaterielWorkRateUnit getWorkRateUnit() {
        return workRateUnit;
    }

    public void setWorkRateUnit(MaterielWorkRateUnit workRateUnit) {
        this.workRateUnit = workRateUnit;
    }

    public MaterielTransportUnit getMaterielTransportUnit() {
        return materielTransportUnit;
    }

    public void setMaterielTransportUnit(MaterielTransportUnit materielTransportUnit) {
        this.materielTransportUnit = materielTransportUnit;
    }

    public boolean isManualIntervention() {
        return manualIntervention;
    }

    public void setManualIntervention(boolean manualIntervention) {
        this.manualIntervention = manualIntervention;
    }

    public Double getTransitVolume() {
        return transitVolume;
    }

    public void setTransitVolume(Double transitVolume) {
        this.transitVolume = transitVolume;
    }
}
