package fr.inra.agrosyst.api.services.domain;

/*
 * #%L
 * Agrosyst :: API
 * $Id: ExtendContext.java 3111 2014-02-05 21:07:15Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/domain/ExtendContext.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import fr.inra.agrosyst.api.entities.Ground;
import fr.inra.agrosyst.api.entities.GrowingSystem;

/**
 * Pour cloner une hierachie d'object, il faut conserver les associations
 * entre les objects initiaux et les clones.
 * 
 * Par exemple, {@code DomainService} clone les sols des domaines, et une fois
 * dans {@code PlotService}, il faut reutiliser les {@code Sol} déjà clonés et non les cloner à
 * nouveau.
 * 
 * Cet objet concerve des maps de clone entre service.
 * 
 * @author chatellier
 */
public class ExtendContext {

    /** Use extends context with extends code but do only duplication. */
    protected boolean duplicateOnly;

    /** Les sols lié au domaine */
    protected Map<Ground, Ground> groundCache;

    /** Les systemes de cultures lié au dispositifs. */
    protected Map<GrowingSystem, GrowingSystem> growingSystemCache;

    public ExtendContext() {
        this(false);
    }

    public ExtendContext(boolean duplicateOnly) {
        this.duplicateOnly = duplicateOnly;
    }

    public boolean isDuplicateOnly() {
        return duplicateOnly;
    }

    public Map<Ground, Ground> getGroundCache() {
        return groundCache;
    }

    public void setGroundCache(Map<Ground, Ground> groundCache) {
        this.groundCache = groundCache;
    }

    public Map<GrowingSystem, GrowingSystem> getGrowingSystemCache() {
        return growingSystemCache;
    }

    public void setGrowingSystemCache(Map<GrowingSystem, GrowingSystem> growingSystemCache) {
        this.growingSystemCache = growingSystemCache;
    }
}
