package fr.inra.agrosyst.api.services.domain;

/*
 * #%L
 * Agrosyst :: API
 * $Id: Equipments.java 4235 2014-07-24 20:45:24Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/domain/Equipments.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.Equipment;
import fr.inra.agrosyst.api.entities.MaterielTransportUnit;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.referential.RefMaterielOutil;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class Equipments {

    public static final Function<ToolsCoupling, ToolsCouplingDto> TOOLS_COUPLING_TO_TOOLS_COUPLING_DTO = new Function<ToolsCoupling, ToolsCouplingDto>() {
        @Override
        public ToolsCouplingDto apply(ToolsCoupling toolsCoupling) {
            ToolsCouplingDto toolsCouplingDto = new ToolsCouplingDto();
            toolsCouplingDto.setTopiaId(toolsCoupling.getTopiaId());
            toolsCouplingDto.setCode(toolsCoupling.getCode());
            toolsCouplingDto.setToolsCouplingName(toolsCoupling.getToolsCouplingName());
            toolsCouplingDto.setMainsActions(toolsCoupling.getMainsActions());
            toolsCouplingDto.setWorkforce(toolsCoupling.getWorkforce());
            toolsCouplingDto.setComment(toolsCoupling.getComment());
            toolsCouplingDto.setWorkRate(toolsCoupling.getWorkRate());
            toolsCouplingDto.setWorkRateUnit(toolsCoupling.getWorkRateUnit());
            toolsCouplingDto.setManualIntervention(toolsCoupling.isManualIntervention());
            toolsCouplingDto.setTransitVolume(toolsCoupling.getTransitVolume());

            if (toolsCoupling.getTractor() != null) {
                toolsCouplingDto.setTractorId(toolsCoupling.getTractor().getTopiaId());
            }

            Collection<Equipment> equipments = toolsCoupling.getEquipments();
            Set<String> equipmentsIds = Sets.newHashSet();
            if (equipments != null && !equipments.isEmpty()) {
                Map<String, Equipment> indexedEquipments = Maps.uniqueIndex(equipments, Entities.GET_TOPIA_ID);
                equipmentsIds.addAll(indexedEquipments.keySet());
                Equipment equipment = equipments.iterator().next();
                if (equipment.getRefMateriel() instanceof RefMaterielOutil) {
                    MaterielTransportUnit materielTransportUnit = ((RefMaterielOutil)equipment.getRefMateriel()).getDonneesTransport2Unite();
                    toolsCouplingDto.setMaterielTransportUnit(materielTransportUnit);
                }
            }
            toolsCouplingDto.setEquipementsKeys(equipmentsIds);

            return toolsCouplingDto;
        }
    };

    public static final Function<ToolsCoupling, String> GET_TOOLS_COUPLING_CODE = new Function<ToolsCoupling, String>() {
        @Override
        public String apply(ToolsCoupling toolsCoupling) {
            return toolsCoupling.getCode();
        }
    };

}
