package fr.inra.agrosyst.api.services.domain;

/*
 * #%L
 * Agrosyst :: API
 * $Id: CroppingPlanSpeciesDto.java 3963 2014-04-02 09:42:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/domain/CroppingPlanSpeciesDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class CroppingPlanSpeciesDto implements Serializable {

    private static final long serialVersionUID = -3018093993881165475L;

    protected String topiaId;
    protected String code;
    protected boolean validated;
    protected Boolean affected;

    protected String speciesId;
    protected String speciesEspece;
    protected String speciesQualifiant;
    protected String speciesTypeSaisonnier;
    protected String speciesDestination;

    protected String varietyId;
    protected String varietyLibelle;

    protected String profil_vegetatif_BBCH;

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean isValidated() {
        return validated;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    public String getSpeciesId() {
        return speciesId;
    }

    public void setSpeciesId(String speciesId) {
        this.speciesId = speciesId;
    }

    public String getSpeciesEspece() {
        return speciesEspece;
    }

    public void setSpeciesEspece(String speciesEspece) {
        this.speciesEspece = speciesEspece;
    }

    public String getSpeciesQualifiant() {
        return speciesQualifiant;
    }

    public void setSpeciesQualifiant(String speciesQualifiant) {
        this.speciesQualifiant = speciesQualifiant;
    }

    public String getSpeciesTypeSaisonnier() {
        return speciesTypeSaisonnier;
    }

    public void setSpeciesTypeSaisonnier(String speciesTypeSaisonnier) {
        this.speciesTypeSaisonnier = speciesTypeSaisonnier;
    }

    public String getSpeciesDestination() {
        return speciesDestination;
    }

    public void setSpeciesDestination(String speciesDestination) {
        this.speciesDestination = speciesDestination;
    }

    public String getVarietyId() {
        return varietyId;
    }

    public void setVarietyId(String varietyId) {
        this.varietyId = varietyId;
    }

    public String getVarietyLibelle() {
        return varietyLibelle;
    }

    public void setVarietyLibelle(String varietyLibelle) {
        this.varietyLibelle = varietyLibelle;
    }

    public String getProfil_vegetatif_BBCH() {
        return profil_vegetatif_BBCH;
    }

    public void setProfil_vegetatif_BBCH(String profil_vegetatif_BBCH) {
        this.profil_vegetatif_BBCH = profil_vegetatif_BBCH;
    }

    public Boolean getAffected() {
        return affected;
    }

    public void setAffected(Boolean affected) {
        this.affected = affected;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((topiaId == null) ? 0 : topiaId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CroppingPlanSpeciesDto other = (CroppingPlanSpeciesDto) obj;
        if (topiaId == null) {
            if (other.topiaId != null)
                return false;
        } else if (!topiaId.equals(other.topiaId))
            return false;
        return true;
    }
}
