package fr.inra.agrosyst.api.services.domain;

/*
 * #%L
 * Agrosyst :: API
 * $Id: CroppingPlanEntryDto.java 4868 2015-03-30 12:20:25Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/domain/CroppingPlanEntryDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.CroppingEntryType;

import java.io.Serializable;
import java.util.Collection;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class CroppingPlanEntryDto implements Serializable {

    private static final long serialVersionUID = -2200338126273122174L;

    protected String topiaId;
    protected String code;
    protected boolean validated;
    protected boolean affected;

    protected String name;
    protected CroppingEntryType type;
    protected Double sellingPrice;
    protected Collection<CroppingPlanSpeciesDto> species;

    protected String color;
    protected String typeImporterValue;

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean isValidated() {
        return validated;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Double getSellingPrice() {
        return sellingPrice;
    }

    public void setSellingPrice(Double sellingPrice) {
        this.sellingPrice = sellingPrice;
    }

    public boolean isIntermediate() {
        return CroppingEntryType.INTERMEDIATE.equals(type);
    }

    public Collection<CroppingPlanSpeciesDto> getSpecies() {
        return species;
    }

    public void setSpecies(Collection<CroppingPlanSpeciesDto> species) {
        this.species = species;
    }

    public void addSpecies(CroppingPlanSpeciesDto speciesDto) {
        if (species == null) {
            species = Lists.newArrayList();
        }
        species.add(speciesDto);
    }

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setType(CroppingEntryType type) {
        this.type = type;
    }

    public CroppingEntryType getType() {
        return type;
    }

    public void setAffected(boolean affected) {
        this.affected = affected;
    }

    public boolean isAffected() {
        return affected;
    }

    public String getTypeImporterValue() {
        return typeImporterValue;
    }

    public void setTypeImporterValue(String typeImporterValue) {
        this.typeImporterValue = typeImporterValue;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((topiaId == null) ? 0 : topiaId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CroppingPlanEntryDto other = (CroppingPlanEntryDto) obj;
        if (topiaId == null) {
            if (other.topiaId != null)
                return false;
        } else if (!topiaId.equals(other.topiaId))
            return false;
        return true;
    }
}

