package fr.inra.agrosyst.api.services.context;

/*
 * #%L
 * Agrosyst :: API
 * $Id: NavigationContextService.java 3564 2014-03-03 13:02:17Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/context/NavigationContextService.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.nuiton.topia.persistence.TopiaEntity;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.DomainDto;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanDto;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemDto;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public interface NavigationContextService extends AgrosystService {

    List<Integer> getAllCampaigns();

    ResultList<Network> getAllNetworks();

    ResultList<DomainDto> getAllDomainsForCampaign(Set<Integer> campaigns, Set<String> networkIds);

    ResultList<GrowingPlanDto> getAllGrowingPlansForDomains(Set<Integer> campaigns, Set<String> domainIds, Set<String> networkIds);

    ResultList<GrowingSystemDto> getAllGrowingSystemsForGrowingPlans(Set<Integer> campaigns, Set<String> domainIds, Set<String> growingPlansIds, Set<String> networkIds);

    NavigationContext verify(NavigationContext navigationContext);

    NavigationContext verify(NavigationContext navigationContext, TopiaEntity newEntity);

    Map<String, String> getNetworks(Set<String> networksIds, int maxCount);

    Map<String, String> getDomains(Set<String> domainsIds, int maxCount);

    Map<String, String> getGrowingPlans(Set<String> growingPlansIds, int maxCount);

    Map<String, String> getGrowingSystems(Set<String> growingSystemsIds, int maxCount);

}
