package fr.inra.agrosyst.api.services.common;

/*
 * #%L
 * Agrosyst :: API
 * $Id: UsageList.java 3768 2014-03-17 13:49:33Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/common/UsageList.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;

/**
 * @author Arnaud Thimel (Code Lutin)
 */
public class UsageList<T> implements Serializable {

    private static final long serialVersionUID = 1010496114867966711L;

    protected ImmutableList<T> elements;
    protected ImmutableMap<String, Boolean> usageMap;

    public UsageList(List<T> elements, Map<String, Boolean> usageMap) {
        if (elements == null) {
            this.elements = ImmutableList.of();
        } else {
            this.elements = ImmutableList.copyOf(elements);
        }
        if (usageMap == null) {
            this.usageMap = ImmutableMap.of();
        } else {
            this.usageMap = ImmutableMap.copyOf(usageMap);
        }
    }

    public static <K> UsageList<K> of(List<K> elements, Map<String, Boolean> usageMap) {
        UsageList<K> result = new UsageList<K>(elements, usageMap);
        return result;
    }

    public List<T> getElements() {
        return elements;
    }

    public Map<String, Boolean> getUsageMap() {
        return usageMap;
    }

}
