package fr.inra.agrosyst.api.services.common;

/*
 * #%L
 * Agrosyst :: API
 * $Id: PricesService.java 4970 2015-06-09 11:56:01Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/common/PricesService.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.Price;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFA;
import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.api.services.practiced.DuplicateCropCyclesContext;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public interface PricesService extends AgrosystService {

    ProductPrices computePricesIndication(Price filter,
                                          String campaigns,
                                          String excludeDomainId,
                                          String excludeZoneId,
                                          String excludePracticedSystemId);

    void updatePrices(List<Price> prices, Domain domain, PracticedSystem practicedSystem);

    List<Price> getDomainPrices(String domainId, List<String> objectIds);

    List<Price> getPracticedSystemPrices(String practicedSystemId);

    /**
     * Duplicate price related to duplicated practiced system, and input from duplication context.
     * @param duplicateContext
     */
    void duplicatePracticedSystemPrices(DuplicateCropCyclesContext duplicateContext);


    String getPriceFertiMinUnifaNaturalId (RefFertiMinUNIFA input);

}
