package fr.inra.agrosyst.api.services.common;

/*
 * #%L
 * Agrosyst :: API
 * $Id: GrowingSystemsIndicator.java 3277 2014-02-17 14:37:17Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/common/GrowingSystemsIndicator.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;

import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.TypeDEPHY;

/**
 * @author Arnaud Thimel (Code Lutin)
 */
public class GrowingSystemsIndicator implements Serializable {

    private static final long serialVersionUID = -881041442589116062L;

    protected TypeDEPHY typeDephy;
    protected Sector sector;
    protected long count;
    protected long active;
    protected long validated;

    public GrowingSystemsIndicator() {
        // total
    }

    public GrowingSystemsIndicator(TypeDEPHY typeDephy) {
        this.typeDephy = typeDephy;
    }

    public GrowingSystemsIndicator(Sector sector) {
        this.sector = sector;
    }

    public TypeDEPHY getTypeDephy() {
        return typeDephy;
    }

    public Sector getSector() {
        return sector;
    }

    public long getCount() {
        return count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public long getActive() {
        return active;
    }

    public void setActive(long active) {
        this.active = active;
    }

    public long getValidated() {
        return validated;
    }

    public void setValidated(long validated) {
        this.validated = validated;
    }
}
