package fr.inra.agrosyst.api.services.common;

/*
 * #%L
 * Agrosyst :: API
 * $Id: AttachmentService.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/common/AttachmentService.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.InputStream;
import java.util.List;

import fr.inra.agrosyst.api.entities.AttachmentMetadata;
import fr.inra.agrosyst.api.services.AgrosystService;

/**
 * Attachment service
 * 
 * @author <a href="mailto:sebastien.grimault@makina-corpus.com">S. Grimault</a>
 */
public interface AttachmentService extends AgrosystService {

    AttachmentMetadata addAttachment(String objectReferenceId, InputStream attachmentFileContent, String filename, String contentType);

    void delete(String attachmentMetadataId);

    InputStream getAttachmentContent(String attachmentMetadataId);

    List<AttachmentMetadata> getAttachmentMetadatas(String objectReferenceId);
    
    long getAttachmentMetadatasCount(String objectReferenceId);

    AttachmentMetadata getAttachmentMetadata(String attachmentTopiaId);
}
