package fr.inra.agrosyst.api.services.action;

/*
 * #%L
 * Agrosyst :: API
 * $Id: ActionService.java 5004 2015-06-23 14:07:24Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/action/ActionService.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.api.services.practiced.DuplicateCropCyclesContext;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author David Cossé
 */
public interface ActionService extends AgrosystService {

    String NEW_ACTION_PREFIX = "NEW-ACTION-";

    /**
     * Create Actions related to the given PracticedIntervention
     *
     * @param actions      Actions related to the intervention
     * @param intervention the intervention to affect to the actions
     * @param speciesCodes intervention species
     */
    Map<String, AbstractAction> createPracticedInterventionActions(
            PracticedIntervention intervention, List<AbstractAction> actions, Set<String> speciesCodes);

    /**
     * Update Actions related to the given PracticedIntervention
     *
     * @param actions      Actions related to the intervention
     * @param intervention the intervention to affect to the actions
     * @param speciesCodes intervention species
     */
    Map<String, AbstractAction> updatePracticedInterventionActions(
            PracticedIntervention intervention, List<AbstractAction> actions, Set<String> speciesCodes);


    /**
     * Create Actions related to the given EffectiveIntervention
     *
     * @param actions      Actions related to the intervention
     * @param intervention the intervention to affect to the actions
     * @param speciesCodes intervention species
     */
    Map<String, AbstractAction> createEffectiveInterventionActions(
            EffectiveIntervention intervention, Collection<AbstractAction> actions, Set<String> speciesCodes);

    /**
     * Update Actions related to the given EffectiveIntervention
     *
     * @param actions      Actions related to the intervention
     * @param intervention the intervention to affect to the actions
     * @param speciesCodes intervention species
     */
    Map<String, AbstractAction> updateEffectiveInterventionActions(
            EffectiveIntervention intervention, Collection<AbstractAction> actions, Set<String> speciesCodes);

    /**
     * Duplicate action as part of practiced intervention or effective intervention.
     *
     * @param duplicateContext duplicate context
     * @param practicedIntervention practiced intervention
     * @param practicedInterventionClone intervention to clone action to
     */
    void duplicatePracticedActions(DuplicateCropCyclesContext duplicateContext, PracticedIntervention practicedIntervention, PracticedIntervention practicedInterventionClone);

    /**
     * Return same action as non persisted one
     * @param originalAction action to clone
     * @return cloned action
     */
    AbstractAction getClonedAbstractAction(AbstractAction originalAction);

    /**
     * migrate action species to targeted species.
     * @param actions all actions to process migration treatment. If there are some ActionSpecies there species code will be change for new one if possible
     * @param speciesByCode species mapped with there code
     * @param fromSpeciesCodeToSpeciesCode species codes that can replace orginial one if not found
     */
    void migrateActionsSpeciesToTargetedSpecies(Collection<AbstractAction> actions,
                                                Map<String, CroppingPlanSpecies> speciesByCode,
                                                Map<String, String> fromSpeciesCodeToSpeciesCode);
}
