package fr.inra.agrosyst.api.services;

/*
 * #%L
 * Agrosyst :: API
 * $Id: ServiceFactory.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/ServiceFactory.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

/**
 * Service factory interface used to get new service instance (local or remote).
 * 
 * @author Eric Chatellier
 */
public interface ServiceFactory {

    /**
     * Build new service instance depending on factory implementation.
     * 
     * @param clazz service interface
     * @return service implementation
     */
    <E extends AgrosystService> E newService(Class<E> clazz);

    /**
     * Create new {@code clazz} instance and inject necessary properties (Service, Config, DAO...)
     * 
     * @param clazz implementation class
     * @return clazz instance
     */
    <I> I newInstance(Class<I> clazz);

}
