package fr.inra.agrosyst.api.services;

/*
 * #%L
 * Agrosyst :: API
 * $Id: ResultList.java 3908 2014-03-29 21:36:38Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/ResultList.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

import org.nuiton.util.PagerBean;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

/**
 * Common agrosyst list result.
 * 
 * Adding PagerBean to all list results.
 *
 * @param <T> element type
 * @author Eric Chatellier
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class ResultList<T> implements Serializable, Iterable<T> {

    /**
     * serialVersionUID.
     */
    private static final long serialVersionUID = -3058449063835056728L;

    /**
     * Result pager.
     */
    protected PagerBean pager;

    /**
     * The list of elements (cannot be modified)
     */
    protected ImmutableList<T> elements;

    public ResultList(List<T> elements, PagerBean pager) {
        if (elements == null) {
            this.elements = ImmutableList.of();
        } else {
            this.elements = ImmutableList.copyOf(elements);
        }
        this.pager = pager;
    }

    public PagerBean getPager() {
        return pager;
    }

    public List<T> getElements() {
        return elements;
    }

    @Override
    public Iterator<T> iterator() {
        Iterator<T> result = elements.iterator();
        return result;
    }

    @Override
    public String toString() {
        String result = Objects.toStringHelper(this).add("pager", pager).add("elements", elements).toString();
        return result;
    }

    public static <T> ResultList<T> of(List<T> elements, PagerBean pager) {
        ResultList<T> result = new ResultList<T>(elements, pager);
        return result;
    }

    public static <I, O> ResultList<O> transform(ResultList<I> source, Function<I, O> function) {
        if (source == null) {
            return null;
        }
        Iterable<O> transformed = Iterables.transform(source.getElements(), function);
        List<O> transformedElements = Lists.newArrayList(transformed);
        ResultList<O> resultList = of(transformedElements, source.getPager());
        return resultList;
    }

    public static <I, O> ResultList<O> transformLazy(ResultList<I> source, Function<I, O> function) {
        if (source == null) {
            return null;
        }
        List<O> transformedElements = Lists.transform(source.getElements(), function);
        ResultList<O> resultList = of(transformedElements, source.getPager());
        return resultList;
    }

}
