package fr.inra.agrosyst.api.services;

/*
 * #%L
 * Agrosyst :: API
 * $Id: AgrosystFilter.java 3402 2014-02-21 17:16:32Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/AgrosystFilter.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;

import fr.inra.agrosyst.api.NavigationContext;

/**
 * Agrosyst common filter base.
 *
 * Contains:
 * <ul>
 *   <li>navigation context (can be null)
 *   <li>requested page
 *   <li>requested result per page
 * </ul>
 *
 * @author Eric Chatellier
 */
public abstract class AgrosystFilter implements Serializable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 2871244551416220532L;

    /** Constant to get all result. */
    public static final int ALL_PAGE_SIZE = -1;

    /** Default result count. */
    public static final int DEFAULT_PAGE_SIZE = 10;

    /** Optional navigation context. */
    protected NavigationContext navigationContext;

    /** Requested page index. */
    protected int page;

    /** Result per page. */
    protected int pageSize = DEFAULT_PAGE_SIZE;

    public NavigationContext getNavigationContext() {
        return navigationContext;
    }

    public void setNavigationContext(NavigationContext navigationContext) {
        this.navigationContext = navigationContext;
    }

    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
    
    public void setAllPageSize() {
        this.pageSize = ALL_PAGE_SIZE;
    }
}
