package fr.inra.agrosyst.api.entities.security;

/*
 * #%L
 * Agrosyst :: API
 * $Id: ComputedUserPermissionImpl.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/entities/security/ComputedUserPermissionImpl.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Objects;

public class ComputedUserPermissionImpl extends ComputedUserPermissionAbstract {

    private static final long serialVersionUID = 7017232072909011251L;

    @Override
    public boolean equals(Object obj) {
        // AThimel 08/10/13 Override Topia behavior to make it work without topiaId
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ComputedUserPermission)) {
            return false;
        }
        ComputedUserPermission other = (ComputedUserPermission) obj;
        if (getTopiaId() == null || other.getTopiaId() == null) {
            // Permissions are the same if they have the same type+object+action
            return Objects.equal(getType(), other.getType())
                    && Objects.equal(getObject(), other.getObject())
                    && Objects.equal(getAction(), other.getAction());
        }
        boolean result = getTopiaId().equals(other.getTopiaId());
        return result;
    }

    @Override
    public int hashCode() {
        int result = action;
        result = 31 * result + (type != null ? type.hashCode() : 0);
        result = 31 * result + (object != null ? object.hashCode() : 0);
        return result;
    }

} //ComputedUserPermissionImpl
