package fr.inra.agrosyst.api.entities.referential;

/*
 * #%L
 * Agrosyst :: API
 * $Id: Referentials.java 4927 2015-05-08 20:57:16Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/entities/referential/Referentials.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Function;

import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoCaseGroundWater;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoFuzzySetGroundWater;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoRulesGroundWater;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesuRunoffPotRulesParc;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class Referentials {

    public static final Function<RefLocation, String> GET_LOCATION_CODE_INSEE = new Function<RefLocation, String>() {
        @Override
        public String apply(RefLocation input) {
            String result = input.getCodeInsee();
            return result;
        }
    };

    public static final Function<RefSolArvalis, String> GET_SOL_ARVALIS_NATURAL_ID = new Function<RefSolArvalis, String>() {
        @Override
        public String apply(RefSolArvalis input) {
            String result = String.format("%s=%s", RefSolArvalis.PROPERTY_ID_TYPE_SOL, input.getId_type_sol());
            return result;
        }
    };

    public static final Function<RefLegalStatus, String> GET_LEGAL_STATUS_NATURAL_ID = new Function<RefLegalStatus, String>() {
        @Override
        public String apply(RefLegalStatus input) {
            String result = String.format("%s=%d", RefLegalStatus.PROPERTY_CODE__INSEE, input.getCode_INSEE());
            return result;
        }
    };

    public static final Function<RefEspece, String> GET_ESPECE_NATURAL_ID = new Function<RefEspece, String>() {
        @Override
        public String apply(RefEspece input) {
            String result = String.format(
                    "%s=%s %s=%s %s=%s %s=%s",
                    RefEspece.PROPERTY_CODE_ESPECE_BOTANIQUE, input.getCode_espece_botanique(),
                    RefEspece.PROPERTY_CODE_QUALIFIANT__AEE, input.getCode_qualifiant_AEE(),
                    RefEspece.PROPERTY_CODE_TYPE_SAISONNIER__AEE, input.getCode_type_saisonnier_AEE(),
                    RefEspece.PROPERTY_CODE_DESTINATION__AEE, input.getCode_destination_AEE()
            );
            return result;
        }
    };

    public static final Function<RefVarieteGeves, String> GET_VARIETE_GEVES_NATURAL_ID = new Function<RefVarieteGeves, String>() {
        @Override
        public String apply(RefVarieteGeves input) {
            String result = String.format("%s=%d", RefVarieteGeves.PROPERTY_NUM__DOSSIER, input.getNum_Dossier());
            return result;
        }
    };

    public static final Function<RefVarietePlantGrape, String> GET_VARIETE_PLANT_GRAPE_NATURAL_ID = new Function<RefVarietePlantGrape, String>() {
        @Override
        public String apply(RefVarietePlantGrape input) {
            String result = String.format("%s=%d", RefVarietePlantGrape.PROPERTY_CODE_VAR, input.getCodeVar());
            return result;
        }
    };

    public static final Function<RefClonePlantGrape, String> GET_CLONE_PLANT_GRAPE_NATURAL_ID = new Function<RefClonePlantGrape, String>() {
        @Override
        public String apply(RefClonePlantGrape input) {
            String result = String.format("%s=%d", RefClonePlantGrape.PROPERTY_CODE_CLONE, input.getCodeClone());
            return result;
        }
    };

    public static final Function<RefEspeceToVariete, String> GET_ESPECE_TO_VARIETE_NATURAL_ID = new Function<RefEspeceToVariete, String>() {
        @Override
        public String apply(RefEspeceToVariete input) {
            String result = String.format(
                    "%s=%s %s=%s",
                    RefEspeceToVariete.PROPERTY_CODE_ESPECE_EDI, input.getCode_espece_edi(),
                    RefEspeceToVariete.PROPERTY_CODE_ESPECE_AUTRE_REFERENTIEL, input.getCode_espece_autre_referentiel()
            );
            return result;
        }
    };

    public static final Function<RefOTEX, String> GET_OTEX_NATURAL_ID = new Function<RefOTEX, String>() {
        @Override
        public String apply(RefOTEX input) {
            String result = String.format(
                    "%s=%s",
                    RefOTEX.PROPERTY_CODE__OTEX_70_POSTES, input.getCode_OTEX_70_postes()
            );
            return result;
        }

    };

    public static final Function<RefOrientationEDI, String> GET_ORIENTATION_EDI_NATURAL_ID = new Function<RefOrientationEDI, String>() {
        @Override
        public String apply(RefOrientationEDI input) {
            String result = String.format(
                    "%s=%s",
                    RefOrientationEDI.PROPERTY_REFERENCE_CODE, input.getReference_code()
            );
            return result;
        }

    };

    public static final Function<RefInterventionAgrosystTravailEDI, String> GET_INTERVENTION_AGROSYST_TRAVAIL_EDI_NATURAL_ID = new Function<RefInterventionAgrosystTravailEDI, String>() {
        @Override
        public String apply(RefInterventionAgrosystTravailEDI input) {
            String result = String.format(
                    "%s=%s",
                    RefInterventionAgrosystTravailEDI.PROPERTY_REFERENCE_CODE, input.getReference_code()
            );
            return result;
        }
    };

    public static final Function<RefStadeEDI, String> GET_STADE_EDI_NATURAL_ID = new Function<RefStadeEDI, String>() {
        @Override
        public String apply(RefStadeEDI input) {
            String result = String.format(
                "%s=%s",
                RefStadeEDI.PROPERTY_AEE, input.getAee()
            );
            return result;
        }
    };

    public static final Function<RefTypeTravailEDI, String> GET_TYPE_TRAVAIL_EDI_NATURAL_ID = new Function<RefTypeTravailEDI, String>() {
        @Override
        public String apply(RefTypeTravailEDI input) {
            String result = String.format(
                    "%s=%s",
                    RefTypeTravailEDI.PROPERTY_REFERENCE_ID, input.getReference_id()
            );
            return result;
        }
    };

    public static final Function<RefMateriel, String> GET_MATERIEL_NATURAL_ID = new Function<RefMateriel, String>() {
        @Override
        public String apply(RefMateriel input) {
            String result = String.format(
                    "%s=%s %s=%s %s=%s %s=%s %s=%f",
                    RefMateriel.PROPERTY_TYPE_MATERIEL1, input.getTypeMateriel1(),
                    RefMateriel.PROPERTY_TYPE_MATERIEL2, input.getTypeMateriel2(),
                    RefMateriel.PROPERTY_TYPE_MATERIEL3, input.getTypeMateriel3(),
                    RefMateriel.PROPERTY_TYPE_MATERIEL4, input.getTypeMateriel4(),
                    RefMateriel.PROPERTY_UNITE_PAR_AN, input.getUniteParAn()
            );
            return result;
        }
    };

    public static final Function<RefMaterielIrrigation, String> GET_MATERIEL_IRRIGATION_NATURAL_ID = new Function<RefMaterielIrrigation, String>() {
        @Override
        public String apply(RefMaterielIrrigation input) {
            String result = GET_MATERIEL_NATURAL_ID.apply(input);
            return result;
        }
    };

    public static final Function<RefMaterielTraction, String> GET_MATERIEL_TRACTION_NATURAL_ID = new Function<RefMaterielTraction, String>() {
        @Override
        public String apply(RefMaterielTraction input) {
            String result = GET_MATERIEL_NATURAL_ID.apply(input);
            return result;
        }
    };

    public static final Function<RefMaterielAutomoteur, String> GET_MATERIEL_AUTOMOTEUR_NATURAL_ID = new Function<RefMaterielAutomoteur, String>() {
        @Override
        public String apply(RefMaterielAutomoteur input) {
            String result = GET_MATERIEL_NATURAL_ID.apply(input);
            return result;
        }
    };

    public static final Function<RefMaterielOutil, String> GET_MATERIEL_OUTIL_NATURAL_ID = new Function<RefMaterielOutil, String>() {
        @Override
        public String apply(RefMaterielOutil input) {
            String result = GET_MATERIEL_NATURAL_ID.apply(input);
            return result;
        }
    };

    public static final Function<RefSolTextureGeppa, String> GET_SOL_TEXTURE_GEPPA_NATURAL_ID = new Function<RefSolTextureGeppa, String>() {
        @Override
        public String apply(RefSolTextureGeppa input) {
            String result = String.format(
                    "%s=%s",
                    RefSolTextureGeppa.PROPERTY_ABBREVIATION_CLASSES_TEXTURALES__GEPAA, input.getAbbreviation_classes_texturales_GEPAA()
            );
            return result;
        }
    };

    public static final Function<RefParcelleZonageEDI, String> GET_PARCELLE_ZONAGE_NATURAL_ID = new Function<RefParcelleZonageEDI, String>() {
        @Override
        public String apply(RefParcelleZonageEDI input) {
            String result = String.format(
                    "%s=%s",
                    RefParcelleZonageEDI.PROPERTY_CODE_ENGAGEMENT_PARCELLE, input.getCode_engagement_parcelle()
            );
            return result;
        }
    };

    public static final Function<RefSolProfondeurIndigo, String> GET_SOL_PROFONDEUR_INDIGO_NATURAL_ID = new Function<RefSolProfondeurIndigo, String>() {
        @Override
        public String apply(RefSolProfondeurIndigo input) {
            String result = String.format(
                    "%s=%s",
                    RefSolProfondeurIndigo.PROPERTY_CLASSE_DE_PROFONDEUR__INDIGO, input.getClasse_de_profondeur_INDIGO()
            );
            return result;
        }
    };

    public static final Function<RefSolCaracteristiqueIndigo, String> GET_SOL_CARACTERISTIQUES_INDIGO_NATURAL_ID = new Function<RefSolCaracteristiqueIndigo, String>() {
        @Override
        public String apply(RefSolCaracteristiqueIndigo input) {
            String result = String.format(
                    "%s=%s %s=%s",
                    RefSolCaracteristiqueIndigo.PROPERTY_ABBREVIATION__INDIGO, input.getAbbreviation_INDIGO(),
                    RefSolCaracteristiqueIndigo.PROPERTY_CLASSE_DE_PROFONDEUR__INDIGO, input.getClasse_de_profondeur_INDIGO()
            );
            return result;
        }
    };

    public static final Function<RefUniteEDI, String> GET_UNITES_EDI_NATURAL_ID = new Function<RefUniteEDI, String>() {
        @Override
        public String apply(RefUniteEDI input) {
            String result = String.format(
                    "%s=%d",
                    RefUniteEDI.PROPERTY_REFERENCE_ID, input.getReference_id()
            );
            return result;
        }
    };

    public static final Function<RefFertiMinUNIFA, String> GET_FERTI_MIN_UNIFA_NATURAL_ID_WITH_NULL = new Function<RefFertiMinUNIFA, String>() {
        @Override
        public String apply(RefFertiMinUNIFA input) {
            String result = String.format("%s=%d %s=%s", RefFertiMinUNIFA.PROPERTY_CATEG, input.getCateg(), RefFertiMinUNIFA.PROPERTY_FORME, input.getForme());
            result += String.format(" %s=%f", RefFertiMinUNIFA.PROPERTY_N, input.getN());
            result += String.format(" %s=%f", RefFertiMinUNIFA.PROPERTY_P2_O5, input.getP2O5());
            result += String.format(" %s=%f", RefFertiMinUNIFA.PROPERTY_K2_O, input.getK2O());
            result += String.format(" %s=%f", RefFertiMinUNIFA.PROPERTY_BORE, input.getBore());
            result += String.format(" %s=%f", RefFertiMinUNIFA.PROPERTY_FER, input.getFer());
            result += String.format(" %s=%f", RefFertiMinUNIFA.PROPERTY_CALCIUM, input.getCalcium());
            result += String.format(" %s=%f", RefFertiMinUNIFA.PROPERTY_MANGANESE, input.getManganese());
            result += String.format(" %s=%f", RefFertiMinUNIFA.PROPERTY_MOLYBDENE, input.getMolybdene());
            result += String.format(" %s=%f", RefFertiMinUNIFA.PROPERTY_MG_O, input.getMgO());
            result += String.format(" %s=%f", RefFertiMinUNIFA.PROPERTY_OXYDE_DE_SODIUM, input.getOxyde_de_sodium());
            result += String.format(" %s=%f", RefFertiMinUNIFA.PROPERTY_S_O3, input.getsO3());
            result += String.format(" %s=%f", RefFertiMinUNIFA.PROPERTY_CUIVRE, input.getCuivre());
            result += String.format(" %s=%f", RefFertiMinUNIFA.PROPERTY_ZINC, input.getZinc());
            return result;
        }
    };

    public static final Function<RefAdventice, String> GET_ADVENTICES_NATURAL_ID = new Function<RefAdventice, String>() {
        @Override
        public String apply(RefAdventice input) {
            String result = String.format(
                    "%s=%s",
                    RefAdventice.PROPERTY_IDENTIFIANT, input.getIdentifiant()
            );
            return result;
        }
    };

    public static final Function<RefNuisibleEDI, String> GET_NUISIBLES_EDI_NATURAL_ID = new Function<RefNuisibleEDI, String>() {
        @Override
        public String apply(RefNuisibleEDI input) {
            String result = String.format(
                    "%s=%s",
                    RefNuisibleEDI.PROPERTY_REFERENCE_ID, input.getReference_id()
            );
            return result;
        }
    };

    public static final Function<RefFertiOrga, String> GET_FERTI_ORGA_NATURAL_ID = new Function<RefFertiOrga, String>() {
        @Override
        public String apply(RefFertiOrga input) {
            String result = String.format(
                    "%s=%s",
                    RefFertiOrga.PROPERTY_IDTYPEEFFLUENT, input.getIdtypeeffluent()
            );
            return result;
        }
    };

    public static final Function<RefFertiEngraisorg, String> GET_FERTI_ENGRAISORG_NATURAL_ID = new Function<RefFertiEngraisorg, String>() {
        @Override
        public String apply(RefFertiEngraisorg input) {
            String result = String.format(
                    "%s=%s",
                    RefFertiEngraisorg.PROPERTY_ID_ENGRAISORG, input.getId_engraisorg()
            );
            return result;
        }
    };

    public static final Function<RefStationMeteo, String> GET_STATION_METEO_NATURAL_ID = new Function<RefStationMeteo, String>() {
        @Override
        public String apply(RefStationMeteo input) {
            String result = String.format(
                    "%s=%s",
                    RefStationMeteo.PROPERTY_AFFECTATION, input.getAffectation()
            );
            return result;
        }
    };

    public static final Function<RefGesCarburant, String> GET_GES_CARBURANTS_NATURAL_ID = new Function<RefGesCarburant, String>() {
        @Override
        public String apply(RefGesCarburant input) {
            String result = String.format(
                    "%s=%s",
                    RefGesCarburant.PROPERTY_LIBELLE_CARBURANT, input.getLibelle_carburant()
            );
            return result;
        }
    };

    public static final Function<RefGesEngrais, String> GET_GES_ENGRAIS_NATURAL_ID = new Function<RefGesEngrais, String>() {
        @Override
        public String apply(RefGesEngrais input) {
            String result = String.format(
                    "%s=%s",
                    RefGesEngrais.PROPERTY_TYPE_ENGRAIS, input.getType_engrais()
            );
            return result;
        }
    };

    public static final Function<RefGesPhyto, String> GET_GES_PHYTO_NATURAL_ID = new Function<RefGesPhyto, String>() {
        @Override
        public String apply(RefGesPhyto input) {
            String result = String.format(
                    "%s=%s",
                    RefGesPhyto.PROPERTY_INTITULE, input.getIntitule()
            );
            return result;
        }
    };

    public static final Function<RefGesSemence, String> GET_GES_SEMENCES_NATURAL_ID = new Function<RefGesSemence, String>() {
        @Override
        public String apply(RefGesSemence input) {
            String result = String.format(
                    "%s=%s",
                    RefGesSemence.PROPERTY_CODE_CULTURE, input.getCode_culture()
            );
            return result;
        }
    };

    public static final Function<RefNrjCarburant, String> GET_NRJ_CARBURANTS_NATURAL_ID = new Function<RefNrjCarburant, String>() {
        @Override
        public String apply(RefNrjCarburant input) {
            String result = String.format(
                    "%s=%s",
                    RefNrjCarburant.PROPERTY_LIBELLE_CARBURANT, input.getLibelle_carburant()
            );
            return result;
        }
    };

    public static final Function<RefNrjEngrais, String> GET_NRJ_ENGRAIS_NATURAL_ID = new Function<RefNrjEngrais, String>() {
        @Override
        public String apply(RefNrjEngrais input) {
            String result = String.format(
                    "%s=%s",
                    RefNrjEngrais.PROPERTY_TYPE_ENGRAIS, input.getType_engrais()
            );
            return result;
        }
    };

    public static final Function<RefNrjPhyto, String> GET_NRJ_PHYTO_NATURAL_ID = new Function<RefNrjPhyto, String>() {
        @Override
        public String apply(RefNrjPhyto input) {
            String result = String.format(
                    "%s=%s",
                    RefNrjPhyto.PROPERTY_INTITULE, input.getIntitule()
            );
            return result;
        }
    };

    public static final Function<RefNrjSemence, String> GET_NRJ_SEMENCES_NATURAL_ID = new Function<RefNrjSemence, String>() {
        @Override
        public String apply(RefNrjSemence input) {
            String result = String.format(
                    "%s=%s",
                    RefNrjSemence.PROPERTY_CODE_CULTURE, input.getCode_culture()
            );
            return result;
        }
    };

    public static final Function<RefNrjGesOutil, String> GET_NRJ_GES_OUTILS_NATURAL_ID = new Function<RefNrjGesOutil, String>() {
        @Override
        public String apply(RefNrjGesOutil input) {
            String result = String.format(
                    "%s=%s",
                    RefNrjGesOutil.PROPERTY_CODE_TYPE_MATERIEL, input.getCode_type_materiel()
            );
            return result;
        }
    };

    public static final Function<RefMesure, String> GET_MESURE_NATURAL_ID = new Function<RefMesure, String>() {
        @Override
        public String apply(RefMesure input) {
            return String.format(
                    "%s=%s %s=%s %s=%s",
                    RefMesure.PROPERTY_CATEGORIE_DE_MESURE, input.getCategorie_de_mesure(),
                    RefMesure.PROPERTY_TYPE_VARIABLE_MESUREE, input.getType_variable_mesuree(),
                    RefMesure.PROPERTY_VARIABLE_MESUREE, input.getVariable_mesuree());
        }
    };

    public static final Function<RefSupportOrganeEDI, String> GET_SUPPORT_ORGANE_EDI_NATURAL_ID = new Function<RefSupportOrganeEDI, String>() {
        @Override
        public String apply(RefSupportOrganeEDI input) {
            return String.format(
                    "%s=%s",
                    RefSupportOrganeEDI.PROPERTY_REFERENCE_ID, input.getReference_id());
        }
    };

    public static final Function<RefStadeNuisibleEDI, String> GET_STADE_NUISIBLE_EDI_NATURAL_ID = new Function<RefStadeNuisibleEDI, String>() {
        @Override
        public String apply(RefStadeNuisibleEDI input) {
            return String.format(
                    "%s=%s",
                    RefStadeNuisibleEDI.PROPERTY_REFERENCE_ID, input.getReference_id());
        }
    };

    public static final Function<RefTypeNotationEDI, String> GET_TYPE_NOTATION_EDI_NATURAL_ID = new Function<RefTypeNotationEDI, String>() {
        @Override
        public String apply(RefTypeNotationEDI input) {
            return String.format(
                    "%s=%s",
                    RefTypeNotationEDI.PROPERTY_REFERENCE_ID, input.getReference_id());
        }
    };

    public static final Function<RefValeurQualitativeEDI, String> GET_VALEUR_QUALITATIVE_EDI_NATURAL_ID = new Function<RefValeurQualitativeEDI, String>() {
        @Override
        public String apply(RefValeurQualitativeEDI input) {
            return String.format(
                    "%s=%s",
                    RefValeurQualitativeEDI.PROPERTY_REFERENCE_ID, input.getReference_id());
        }
    };

    public static final Function<RefUnitesQualifiantEDI, String> GET_UNITES_QUALIFIANT_EDI_NATURAL_ID = new Function<RefUnitesQualifiantEDI, String>() {
        @Override
        public String apply(RefUnitesQualifiantEDI input) {
            return String.format(
                    "%s=%s",
                    RefUnitesQualifiantEDI.PROPERTY_REFERENCE_ID, input.getReference_id());
        }
    };

    public static final Function<RefActaTraitementsProduit, String> GET_ACTA_TRAITEMENTS_PRODUITS_NATURAL_ID = new Function<RefActaTraitementsProduit, String>() {

        @Override
        public String apply(RefActaTraitementsProduit input) {
            return String.format(
                    "%s=%s %s=%d",
                    RefActaTraitementsProduit.PROPERTY_ID_PRODUIT, input.getId_produit(),
                    RefActaTraitementsProduit.PROPERTY_ID_TRAITEMENT, input.getId_traitement()
            );
        }
    };

    public static final Function<RefActaTraitementsProduitsCateg, String> GET_ACTA_TRAITEMENTS_PRODUITS_CATEG_NATURAL_ID = new Function<RefActaTraitementsProduitsCateg, String>() {
        @Override
        public String apply(RefActaTraitementsProduitsCateg input) {
            return String.format(
                    "%s=%d",
                    RefActaTraitementsProduitsCateg.PROPERTY_ID_TRAITEMENT, input.getId_traitement()
            );
        }
    };

    public static final Function<RefActaSubstanceActive, String> GET_ACTA_SUBSTANCE_ACTIVE_NATURAL_ID = new Function<RefActaSubstanceActive, String>() {

        @Override
        public String apply(RefActaSubstanceActive input) {
            return String.format(
                    "%s=%s %s=%s",
                    RefActaSubstanceActive.PROPERTY_ID_PRODUIT, input.getId_produit(),
                    RefActaSubstanceActive.PROPERTY_NOM_COMMUN_SA, input.getNom_commun_sa()
            );
        }
    };

    public static final Function<RefProtocoleVgObs, String> GET_PROTOCOLE_VG_OBS_NATURAL_ID = new Function<RefProtocoleVgObs, String>() {

        @Override
        public String apply(RefProtocoleVgObs input) {
            return String.format(
                    "%s=%s %s=%s %s=%s %s=%s %s=%s",
                    RefProtocoleVgObs.PROPERTY_PROTOCOLE_CODE_PROTOCOLE, input.getProtocole_code_protocole(),
                    RefProtocoleVgObs.PROPERTY_LIGNE_CODE_LIGNE_PROTOCOLE, input.getLigne_code_ligne_protocole(),
                    RefProtocoleVgObs.PROPERTY_RELEVE_NO_RELEVE, input.getReleve_no_releve(),
                    RefProtocoleVgObs.PROPERTY_RELEVE_QUALIFIANT_UNITE_MESURE_CODE, input.getReleve_qualifiant_unite_mesure_code(),
                    RefProtocoleVgObs.PROPERTY_CLASSE_NO_CLASSE, input.getClasse_no_classe()
            );
        }
    };

    public static final Function<RefElementVoisinage, String> GET_ELEMENT_VOISINAGE_NATURAL_ID = new Function<RefElementVoisinage, String>() {
        @Override
        public String apply(RefElementVoisinage input) {
            return String.format(
                    "%s=%d",
                    RefElementVoisinage.PROPERTY_ID_REF_INFRASTRUCTURE, input.getId_ref_infrastructure()
            );
        }
    };

    public static final Function<RefRcesoRulesGroundWater, String> GET_RCESO_RULES_GROUND_WATER_NATURAL_ID = new Function<RefRcesoRulesGroundWater, String>() {
        @Override
        public String apply(RefRcesoRulesGroundWater input) {
            return String.format(
                    "%s=%d %s=%d %s=%s %s=%s %s=%s %s=%s",
                    RefRcesoRulesGroundWater.PROPERTY_CASE_NUMBER, input.getCaseNumber(),
                    RefRcesoRulesGroundWater.PROPERTY_RULE_NUMBER, input.getRuleNumber(),
                    RefRcesoRulesGroundWater.PROPERTY_FSET_ORGC, input.getFset_orgc(),
                    RefRcesoRulesGroundWater.PROPERTY_FSET_DEPTH, input.getFset_depth(),
                    RefRcesoRulesGroundWater.PROPERTY_FSET_KOC, input.getFset_koc(),
                    RefRcesoRulesGroundWater.PROPERTY_FSET_DT50, input.getFset_dt50()
            );
        }
    };

    public static final Function<RefRcesoFuzzySetGroundWater, String> GET_RCESO_FUZZYSET_GROUND_WATER_NATURAL_ID = new Function<RefRcesoFuzzySetGroundWater, String>() {
        @Override
        public String apply(RefRcesoFuzzySetGroundWater input) {
            return String.format(
                    "%s=%d %s=%s %s=%s",
                    RefRcesoFuzzySetGroundWater.PROPERTY_CASE_NUMBER, input.getCaseNumber(),
                    RefRcesoFuzzySetGroundWater.PROPERTY_VARIABLES, input.getVariables(),
                    RefRcesoFuzzySetGroundWater.PROPERTY_FUZZY_SET, input.getFuzzySet()
            );
        }
    };

    public static final Function<RefRcesoCaseGroundWater, String> GET_RCESO_CASE_GROUND_WATER_NATURAL_ID = new Function<RefRcesoCaseGroundWater, String>() {
        @Override
        public String apply(RefRcesoCaseGroundWater input) {
            return String.format(
                    "%s=%d %s=%s %s=%s %s=%s",
                    RefRcesoCaseGroundWater.PROPERTY_CLIMATE, input.getClimate(),
                    RefRcesoCaseGroundWater.PROPERTY_APPLICATION_PERIOD, input.getApplicationPeriod(),
                    RefRcesoCaseGroundWater.PROPERTY_SURFACE_TEXTURE, input.getSurface_texture(),
                    RefRcesoCaseGroundWater.PROPERTY_SUBSOIL_TEXTURE, input.getSubsoil_texture()
            );
        }
    };
    
    public static final Function<RefRcesuRunoffPotRulesParc, String> GET_RCESU_RUNOFF_POT_RULES_PARC_NATURAL_ID = new Function<RefRcesuRunoffPotRulesParc, String>() {
        @Override
        public String apply(RefRcesuRunoffPotRulesParc input) {
            return String.format(
                    "%s=%s %s=%s %s=%s %s=%s",
                    RefRcesuRunoffPotRulesParc.PROPERTY_SOIL_TEXTURE, input.getSoil_texture(),
                    RefRcesuRunoffPotRulesParc.PROPERTY_SLOPE, input.getSlope().name(),
                    RefRcesuRunoffPotRulesParc.PROPERTY_BATTANCE, input.isBattance(),
                    RefRcesuRunoffPotRulesParc.PROPERTY_HYDROMORPHISMS, input.isHydromorphisms()
            );
        }
    };

    public static final Function<RefPhytoSubstanceActiveIphy, String> GET_PHYTO_SUBSTANCE_ACTIVE_IPHY_NATURAL_ID = new Function<RefPhytoSubstanceActiveIphy, String>() {
        @Override
        public String apply(RefPhytoSubstanceActiveIphy input) {
            return String.format(
                    "%s=%s",
                    RefPhytoSubstanceActiveIphy.PROPERTY_NOM_SA, input.getNom_sa()
            );
        }
    };

    public static final Function<RefTypeAgriculture, String> GET_TYPE_AGRICULTURE_NATURAL_ID = new Function<RefTypeAgriculture, String>() {
        @Override
        public String apply(RefTypeAgriculture input) {
            return String.format(
                    "%s=%d",
                    RefTypeAgriculture.PROPERTY_REFERENCE_ID, input.getReference_id()
            ); 
        }
    };

    public static final Function<RefActaDosageSPC, String> GET_ACTA_DOSAGE_SPC_NATURAL_ID = new Function<RefActaDosageSPC, String>() {
        @Override
        public String apply(RefActaDosageSPC input) {
            return String.format(
                    "%s=%s %s=%s %s=%s %s=%e %s=%s",
                    RefActaDosageSPC.PROPERTY_ID_PRODUIT, input.getId_produit(),
                    RefActaDosageSPC.PROPERTY_ID_TRAITEMENT, input.getId_traitement(),
                    RefActaDosageSPC.PROPERTY_ID_CULTURE, input.getId_culture(),
                    RefActaDosageSPC.PROPERTY_DOSAGE_SPC_VALEUR, input.getDosage_spc_valeur(),
                    RefActaDosageSPC.PROPERTY_DOSAGE_SPC_COMMENTAIRE, input.getDosage_spc_commentaire()
            );
        }
    };

    public static final Function<RefActaGroupeCultures, String> GET_ACTA_GROUPE_CULTURES_NATURAL_ID = new Function<RefActaGroupeCultures, String>() {
        @Override
        public String apply(RefActaGroupeCultures input) {
            return String.format(
                    "%s=%s %s=%s",
                    RefActaGroupeCultures.PROPERTY_ID_CULTURE, input.getId_culture(),
                    RefActaGroupeCultures.PROPERTY_ID_GROUPE_CULTURE, input.getId_groupe_culture()
            );
        }
    };

    public static final Function<RefLienCulturesEdiActa, String> GET_LIEN_CULTURES_EDI_ACTA_NATURAL_ID = new Function<RefLienCulturesEdiActa, String>() {
        @Override
        public String apply(RefLienCulturesEdiActa input) {
            return String.format(
                    "%s=%s %s=%s %s=%s %s=%s",
                    RefLienCulturesEdiActa.PROPERTY_CODE_ESPECE_BOTANIQUE, input.getCode_espece_botanique(),
                    RefLienCulturesEdiActa.PROPERTY_CODE_QUALIFIANT_AEE, input.getCode_qualifiant_aee(),
                    RefLienCulturesEdiActa.PROPERTY_CODE_TYPE_SAISONNIER_AEE, input.getCode_type_saisonnier_aee(),
                    RefLienCulturesEdiActa.PROPERTY_CODE_DESTINATION_AEE, input.getCode_destination_aee()
            );
        }
    };

    public static final Function<RefSaActaIphy, String> GET_SA_ACTA_IPHY_NATURAL_ID = new Function<RefSaActaIphy, String>() {
        @Override
        public String apply(RefSaActaIphy input) {
            return String.format(
                    "%s=%s",
                    RefSaActaIphy.PROPERTY_NOM_SA_ACTA, input.getNom_sa_acta()
            );
        }
    };
    
    public static final Function<RefTraitSdC, String> GET_TRAIT_SDC_NATURAL_ID = new Function<RefTraitSdC, String>() {
        @Override
        public String apply(RefTraitSdC input) {
            return String.format(
                    "%s=%s",
                    RefTraitSdC.PROPERTY_ID_TRAIT, input.getId_trait()
            );
        }
    };

    public static final Function<RefCultureEdiGroupeCouvSol, String> GET_CULTURE_EDI_GROUP_COUV_SOL_NATURAL_ID = new Function<RefCultureEdiGroupeCouvSol, String>() {
        @Override
        public String apply(RefCultureEdiGroupeCouvSol input) {
            return String.format(
                    "%s=%s %s=%s %s=%s %s=%s",
                    RefCultureEdiGroupeCouvSol.PROPERTY_CODE_ESPECE_BOTANIQUE, input.getCode_espece_botanique(),
                    RefCultureEdiGroupeCouvSol.PROPERTY_CODE_QUALIFIANT_AEE, input.getCode_qualifiant_aee(),
                    RefCultureEdiGroupeCouvSol.PROPERTY_CODE_TYPE_SAISONNIER_AEE, input.getCode_type_saisonnier_aee(),
                    RefCultureEdiGroupeCouvSol.PROPERTY_CODE_DESTINATION_AEE, input.getCode_destination_aee()
            );
        }
    };

    public static final Function<RefCouvSolAnnuelle, String> GET_COUV_SOL_ANNUELLE_NATURAL_ID = new Function<RefCouvSolAnnuelle, String>() {
        @Override
        public String apply(RefCouvSolAnnuelle input) {
            return String.format(
                    "%s=%s %s=%s %s=%s %s=%s",
                    RefCouvSolAnnuelle.PROPERTY_VITESSE_COUV, input.getVitesseCouv(),
                    RefCouvSolAnnuelle.PROPERTY_PERIODE_SEMIS, input.getPeriodeSemis(),
                    RefCouvSolAnnuelle.PROPERTY_DEBUT_INTER, input.getDebut_inter(),
                    RefCouvSolAnnuelle.PROPERTY_FIN_INTER, input.getFin_inter()
            );
        }
    };

    public static final Function<RefCouvSolPerenne, String> GET_COUV_SOL_PERENNE_NATURAL_ID = new Function<RefCouvSolPerenne, String>() {
        @Override
        public String apply(RefCouvSolPerenne input) {
            return String.format(
                    "%s=%s %s=%s %s=%s %s=%s",
                    RefCouvSolPerenne.PROPERTY_VITESSE_COUV, input.getVitesseCouv(),
                    RefCouvSolPerenne.PROPERTY_PHASE, input.getPhase(),
                    RefCouvSolPerenne.PROPERTY_DEBUT_INTER, input.getDebut_inter(),
                    RefCouvSolPerenne.PROPERTY_FIN_INTER, input.getFin_inter()
            );
        }
    };

    public static final Function<RefDepartmentShape, String> GET_DEPARTMENT_SHAPE_NATURAL_ID = new Function<RefDepartmentShape, String>() {
        @Override
        public String apply(RefDepartmentShape input) {
            return String.format(
                    "%s=%s",
                    RefDepartmentShape.PROPERTY_DEPARTMENT, input.getDepartment()
            );
        }
    };

    public static final Function<RefZoneClimatiqueIphy, String> GET_ZONE_CLIMATIQUE_NATURAL_ID = new Function<RefZoneClimatiqueIphy, String>() {
        @Override
        public String apply(RefZoneClimatiqueIphy input) {
            return String.format(
                    "%s=%s",
                    RefZoneClimatiqueIphy.PROPERTY_DEPARTEMENT, input.getDepartement()
            );
        }
    };
}
