package fr.inra.agrosyst.api.entities.practiced;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.OrchardFrutalForm;
import fr.inra.agrosyst.api.entities.PollinatorSpreadMode;
import fr.inra.agrosyst.api.entities.VineFrutalForm;
import fr.inra.agrosyst.api.entities.WeedType;
import fr.inra.agrosyst.api.entities.referential.RefOrientationEDI;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:20 CET 2015")
public abstract class PracticedPerennialCropCycleAbstract extends PracticedCropCycleImpl implements PracticedPerennialCropCycle {

    /**
     * Nom de l'attribut en BD : plantingYear
     */
    protected Integer plantingYear;

    /**
     * Nom de l'attribut en BD : plantingDensity
     */
    protected Double plantingDensity;

    /**
     * Nom de l'attribut en BD : plantingInterFurrow
     */
    protected Integer plantingInterFurrow;

    /**
     * Nom de l'attribut en BD : plantingSpacing
     */
    protected Integer plantingSpacing;

    /**
     * Nom de l'attribut en BD : plantingDeathRate
     */
    protected Double plantingDeathRate;

    /**
     * Nom de l'attribut en BD : plantingDeathRateMeasureYear
     */
    protected Integer plantingDeathRateMeasureYear;

    /**
     * Nom de l'attribut en BD : croppingPlanEntryCode
     */
    protected String croppingPlanEntryCode;

    /**
     * Nom de l'attribut en BD : pollinator
     */
    protected boolean pollinator;

    /**
     * Nom de l'attribut en BD : pollinatorPercent
     */
    protected Double pollinatorPercent;

    /**
     * Nom de l'attribut en BD : otherCharacteristics
     */
    protected String otherCharacteristics;

    /**
     * Nom de l'attribut en BD : solOccupationPercent
     */
    protected double solOccupationPercent;

    /**
     * Nom de l'attribut en BD : foliageHeight
     */
    protected Double foliageHeight;

    /**
     * Nom de l'attribut en BD : foliageThickness
     */
    protected Double foliageThickness;

    /**
     * Nom de l'attribut en BD : orchardFrutalForm
     */
    protected OrchardFrutalForm orchardFrutalForm;

    /**
     * Nom de l'attribut en BD : orientation
     */
    protected RefOrientationEDI orientation;

    /**
     * Nom de l'attribut en BD : weedType
     */
    protected WeedType weedType;

    /**
     * Nom de l'attribut en BD : cropCyclePhases
     */
    protected Collection<PracticedCropCyclePhase> cropCyclePhases;

    /**
     * Nom de l'attribut en BD : practicedCropCycleSpecies
     */
    protected Collection<PracticedCropCycleSpecies> practicedCropCycleSpecies;

    /**
     * Nom de l'attribut en BD : vineFrutalForm
     */
    protected VineFrutalForm vineFrutalForm;

    /**
     * Nom de l'attribut en BD : pollinatorSpreadMode
     */
    protected PollinatorSpreadMode pollinatorSpreadMode;

    private static final long serialVersionUID = 7017278059106809446L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    @Override
    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        super.accept0(visitor);
        visitor.visit(this, PROPERTY_PLANTING_YEAR, Integer.class, plantingYear);
        visitor.visit(this, PROPERTY_PLANTING_DENSITY, Double.class, plantingDensity);
        visitor.visit(this, PROPERTY_PLANTING_INTER_FURROW, Integer.class, plantingInterFurrow);
        visitor.visit(this, PROPERTY_PLANTING_SPACING, Integer.class, plantingSpacing);
        visitor.visit(this, PROPERTY_PLANTING_DEATH_RATE, Double.class, plantingDeathRate);
        visitor.visit(this, PROPERTY_PLANTING_DEATH_RATE_MEASURE_YEAR, Integer.class, plantingDeathRateMeasureYear);
        visitor.visit(this, PROPERTY_CROPPING_PLAN_ENTRY_CODE, String.class, croppingPlanEntryCode);
        visitor.visit(this, PROPERTY_POLLINATOR, boolean.class, pollinator);
        visitor.visit(this, PROPERTY_POLLINATOR_PERCENT, Double.class, pollinatorPercent);
        visitor.visit(this, PROPERTY_OTHER_CHARACTERISTICS, String.class, otherCharacteristics);
        visitor.visit(this, PROPERTY_SOL_OCCUPATION_PERCENT, double.class, solOccupationPercent);
        visitor.visit(this, PROPERTY_FOLIAGE_HEIGHT, Double.class, foliageHeight);
        visitor.visit(this, PROPERTY_FOLIAGE_THICKNESS, Double.class, foliageThickness);
        visitor.visit(this, PROPERTY_ORCHARD_FRUTAL_FORM, OrchardFrutalForm.class, orchardFrutalForm);
        visitor.visit(this, PROPERTY_ORIENTATION, RefOrientationEDI.class, orientation);
        visitor.visit(this, PROPERTY_WEED_TYPE, WeedType.class, weedType);
        visitor.visit(this, PROPERTY_CROP_CYCLE_PHASES, Collection.class, PracticedCropCyclePhase.class, cropCyclePhases);
        visitor.visit(this, PROPERTY_PRACTICED_CROP_CYCLE_SPECIES, Collection.class, PracticedCropCycleSpecies.class, practicedCropCycleSpecies);
        visitor.visit(this, PROPERTY_VINE_FRUTAL_FORM, VineFrutalForm.class, vineFrutalForm);
        visitor.visit(this, PROPERTY_POLLINATOR_SPREAD_MODE, PollinatorSpreadMode.class, pollinatorSpreadMode);
    }

    @Override
    public void setPlantingYear(Integer plantingYear) {
        this.plantingYear = plantingYear;
    }

    @Override
    public Integer getPlantingYear() {
        Integer result = this.plantingYear;
        return result;
    }

    @Override
    public void setPlantingDensity(Double plantingDensity) {
        this.plantingDensity = plantingDensity;
    }

    @Override
    public Double getPlantingDensity() {
        Double result = this.plantingDensity;
        return result;
    }

    @Override
    public void setPlantingInterFurrow(Integer plantingInterFurrow) {
        this.plantingInterFurrow = plantingInterFurrow;
    }

    @Override
    public Integer getPlantingInterFurrow() {
        Integer result = this.plantingInterFurrow;
        return result;
    }

    @Override
    public void setPlantingSpacing(Integer plantingSpacing) {
        this.plantingSpacing = plantingSpacing;
    }

    @Override
    public Integer getPlantingSpacing() {
        Integer result = this.plantingSpacing;
        return result;
    }

    @Override
    public void setPlantingDeathRate(Double plantingDeathRate) {
        this.plantingDeathRate = plantingDeathRate;
    }

    @Override
    public Double getPlantingDeathRate() {
        Double result = this.plantingDeathRate;
        return result;
    }

    @Override
    public void setPlantingDeathRateMeasureYear(Integer plantingDeathRateMeasureYear) {
        this.plantingDeathRateMeasureYear = plantingDeathRateMeasureYear;
    }

    @Override
    public Integer getPlantingDeathRateMeasureYear() {
        Integer result = this.plantingDeathRateMeasureYear;
        return result;
    }

    @Override
    public void setCroppingPlanEntryCode(String croppingPlanEntryCode) {
        this.croppingPlanEntryCode = croppingPlanEntryCode;
    }

    @Override
    public String getCroppingPlanEntryCode() {
        String result = this.croppingPlanEntryCode;
        return result;
    }

    @Override
    public void setPollinator(boolean pollinator) {
        this.pollinator = pollinator;
    }

    @Override
    public boolean isPollinator() {
        boolean result = this.pollinator;
        return result;
    }

    @Override
    public void setPollinatorPercent(Double pollinatorPercent) {
        this.pollinatorPercent = pollinatorPercent;
    }

    @Override
    public Double getPollinatorPercent() {
        Double result = this.pollinatorPercent;
        return result;
    }

    @Override
    public void setOtherCharacteristics(String otherCharacteristics) {
        this.otherCharacteristics = otherCharacteristics;
    }

    @Override
    public String getOtherCharacteristics() {
        String result = this.otherCharacteristics;
        return result;
    }

    @Override
    public void setSolOccupationPercent(double solOccupationPercent) {
        this.solOccupationPercent = solOccupationPercent;
    }

    @Override
    public double getSolOccupationPercent() {
        double result = this.solOccupationPercent;
        return result;
    }

    @Override
    public void setFoliageHeight(Double foliageHeight) {
        this.foliageHeight = foliageHeight;
    }

    @Override
    public Double getFoliageHeight() {
        Double result = this.foliageHeight;
        return result;
    }

    @Override
    public void setFoliageThickness(Double foliageThickness) {
        this.foliageThickness = foliageThickness;
    }

    @Override
    public Double getFoliageThickness() {
        Double result = this.foliageThickness;
        return result;
    }

    @Override
    public void setOrchardFrutalForm(OrchardFrutalForm orchardFrutalForm) {
        this.orchardFrutalForm = orchardFrutalForm;
    }

    @Override
    public OrchardFrutalForm getOrchardFrutalForm() {
        OrchardFrutalForm result = this.orchardFrutalForm;
        return result;
    }

    @Override
    public void setOrientation(RefOrientationEDI orientation) {
        this.orientation = orientation;
    }

    @Override
    public RefOrientationEDI getOrientation() {
        RefOrientationEDI result = this.orientation;
        return result;
    }

    @Override
    public void setWeedType(WeedType weedType) {
        this.weedType = weedType;
    }

    @Override
    public WeedType getWeedType() {
        WeedType result = this.weedType;
        return result;
    }

    @Override
    public void addCropCyclePhases(PracticedCropCyclePhase cropCyclePhases) {
        if (this.cropCyclePhases == null) {
            this.cropCyclePhases = new LinkedList<PracticedCropCyclePhase>();
        }
        this.cropCyclePhases.add(cropCyclePhases);
    }

    @Override
    public void addAllCropCyclePhases(Iterable<PracticedCropCyclePhase> cropCyclePhases) {
        if (cropCyclePhases == null) {
            return;
        }
        for (PracticedCropCyclePhase item : cropCyclePhases) {
            addCropCyclePhases(item);
        }
    }

    @Override
    public void setCropCyclePhases(Collection<PracticedCropCyclePhase> cropCyclePhases) {
        this.cropCyclePhases = cropCyclePhases;
    }

    @Override
    public void removeCropCyclePhases(PracticedCropCyclePhase cropCyclePhases) {
        if (this.cropCyclePhases == null || !this.cropCyclePhases.remove(cropCyclePhases)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearCropCyclePhases() {
        if (this.cropCyclePhases == null) {
            return;
        }
        this.cropCyclePhases.clear();
    }

    @Override
    public Collection<PracticedCropCyclePhase> getCropCyclePhases() {
        return cropCyclePhases;
    }

    @Override
    public PracticedCropCyclePhase getCropCyclePhasesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(cropCyclePhases, topiaId);
    }

    @Override
    public Collection<String> getCropCyclePhasesTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhase> tmp = getCropCyclePhases();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeCropCyclePhases() {
        if (cropCyclePhases == null) {
            return 0;
        }
        return cropCyclePhases.size();
    }

    @Override
    public boolean isCropCyclePhasesEmpty() {
        int size = sizeCropCyclePhases();
        return size == 0;
    }

    @Override
    public boolean isCropCyclePhasesNotEmpty() {
        boolean empty = isCropCyclePhasesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsCropCyclePhases(PracticedCropCyclePhase cropCyclePhases) {
        boolean contains = this.cropCyclePhases !=null && this.cropCyclePhases.contains(cropCyclePhases);
        return contains;
    }

    @Override
    public void addPracticedCropCycleSpecies(PracticedCropCycleSpecies practicedCropCycleSpecies) {
        if (this.practicedCropCycleSpecies == null) {
            this.practicedCropCycleSpecies = new LinkedList<PracticedCropCycleSpecies>();
        }
        practicedCropCycleSpecies.setCycle(this);
        this.practicedCropCycleSpecies.add(practicedCropCycleSpecies);
    }

    @Override
    public void addAllPracticedCropCycleSpecies(Iterable<PracticedCropCycleSpecies> practicedCropCycleSpecies) {
        if (practicedCropCycleSpecies == null) {
            return;
        }
        for (PracticedCropCycleSpecies item : practicedCropCycleSpecies) {
            addPracticedCropCycleSpecies(item);
        }
    }

    @Override
    public void setPracticedCropCycleSpecies(Collection<PracticedCropCycleSpecies> practicedCropCycleSpecies) {
        this.practicedCropCycleSpecies = practicedCropCycleSpecies;
    }

    @Override
    public void removePracticedCropCycleSpecies(PracticedCropCycleSpecies practicedCropCycleSpecies) {
        if (this.practicedCropCycleSpecies == null || !this.practicedCropCycleSpecies.remove(practicedCropCycleSpecies)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        practicedCropCycleSpecies.setCycle(null);
    }

    @Override
    public void clearPracticedCropCycleSpecies() {
        if (this.practicedCropCycleSpecies == null) {
            return;
        }
        for (PracticedCropCycleSpecies item : this.practicedCropCycleSpecies) {
            item.setCycle(null);
        }
        this.practicedCropCycleSpecies.clear();
    }

    @Override
    public Collection<PracticedCropCycleSpecies> getPracticedCropCycleSpecies() {
        return practicedCropCycleSpecies;
    }

    @Override
    public PracticedCropCycleSpecies getPracticedCropCycleSpeciesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(practicedCropCycleSpecies, topiaId);
    }

    @Override
    public Collection<String> getPracticedCropCycleSpeciesTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleSpecies> tmp = getPracticedCropCycleSpecies();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizePracticedCropCycleSpecies() {
        if (practicedCropCycleSpecies == null) {
            return 0;
        }
        return practicedCropCycleSpecies.size();
    }

    @Override
    public boolean isPracticedCropCycleSpeciesEmpty() {
        int size = sizePracticedCropCycleSpecies();
        return size == 0;
    }

    @Override
    public boolean isPracticedCropCycleSpeciesNotEmpty() {
        boolean empty = isPracticedCropCycleSpeciesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsPracticedCropCycleSpecies(PracticedCropCycleSpecies practicedCropCycleSpecies) {
        boolean contains = this.practicedCropCycleSpecies !=null && this.practicedCropCycleSpecies.contains(practicedCropCycleSpecies);
        return contains;
    }

    @Override
    public void setVineFrutalForm(VineFrutalForm vineFrutalForm) {
        this.vineFrutalForm = vineFrutalForm;
    }

    @Override
    public VineFrutalForm getVineFrutalForm() {
        VineFrutalForm result = this.vineFrutalForm;
        return result;
    }

    @Override
    public void setPollinatorSpreadMode(PollinatorSpreadMode pollinatorSpreadMode) {
        this.pollinatorSpreadMode = pollinatorSpreadMode;
    }

    @Override
    public PollinatorSpreadMode getPollinatorSpreadMode() {
        PollinatorSpreadMode result = this.pollinatorSpreadMode;
        return result;
    }

} //PracticedPerennialCropCycleAbstract
